/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import java.security.InvalidParameterException;

public class FileInfo {
    private final long dataRead;
    private final long totalData;
    private final boolean pauseFlag;
    private final long time;

    public FileInfo(long dataRead, long totalData, boolean pauseFlag, long time) {
        this.dataRead = dataRead;
        this.totalData = totalData;
        this.pauseFlag = pauseFlag;
        this.time = time;
    }

    public FileInfo(String dString, String tString) {
        if (dString == null || tString == null) {
            throw new InvalidParameterException("Null string");
        }
        dString = dString.trim();
        tString = tString.trim();
        if (dString.length() < 5 || tString.length() < 3) {
            throw new InvalidParameterException("Empty String");
        }
        dString = dString.substring(2);
        tString = tString.substring(2);
        String[] split = dString.split("/");
        if (split.length != 3) {
            throw new InvalidParameterException("Couldn't parse String");
        }
        this.dataRead = Long.parseLong(split[0]);
        this.totalData = Long.parseLong(split[1]);
        this.pauseFlag = split[2].equals("1");
        this.time = Long.parseLong(tString);
    }

    public long getDataRead() {
        return this.dataRead;
    }

    public long getTotalData() {
        return this.totalData;
    }

    public boolean isPaused() {
        if (this.totalData < 1L) {
            return false;
        }
        return this.pauseFlag;
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return "D:" + this.dataRead + "/" + this.totalData + "/" + (this.pauseFlag ? "1" : "0") + " T:" + this.time;
    }
}

