/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import de.sg_o.lib.photoNet.netData.DataTransferBlock;
import de.sg_o.lib.photoNet.netData.Status;
import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRegularCommand;
import de.sg_o.lib.photoNet.networkIO.NetRequestBinary;
import de.sg_o.lib.photoNet.photonFile.PhotonFileMeta;
import de.sg_o.lib.photoNet.photonFile.PhotonFilePreview;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;

public class FileListItem {
    private final NetIO io;
    private final String baseDir;
    private final String name;
    private final long size;
    private final boolean folder;

    public FileListItem(String baseDir, String name, long size, boolean folder, NetIO io) {
        this.baseDir = baseDir;
        this.name = name;
        this.size = size;
        this.folder = folder;
        this.io = io;
    }

    public FileListItem(String baseDir, String info, NetIO io) {
        if (baseDir == null) {
            throw new InvalidParameterException("Null string");
        }
        this.baseDir = baseDir;
        if (info == null) {
            throw new InvalidParameterException("Null string");
        }
        if (info.length() < 1) {
            throw new InvalidParameterException("Couldn't parse String");
        }
        if (info.startsWith("->")) {
            this.folder = true;
            this.size = 0L;
            this.name = info.substring(2);
        } else {
            this.folder = false;
            String[] split = info.split("\\s+");
            if (split.length < 2) {
                throw new InvalidParameterException("Couldn't parse String");
            }
            this.size = Long.parseLong(split[split.length - 1]);
            this.name = info.substring(0, info.length() - split[split.length - 1].length()).trim();
        }
        this.io = io;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public String getFullPath() {
        if (this.baseDir.length() < 1) {
            return this.name;
        }
        return this.baseDir + "/" + this.name;
    }

    public PhotonFileMeta getMeta() throws UnsupportedEncodingException {
        if (this.folder) {
            return null;
        }
        long size = this.openFile();
        if (size != this.size) {
            return null;
        }
        DataTransferBlock response = this.readNext();
        this.closeFile();
        if (response == null) {
            return null;
        }
        if (!response.verifyChecksum()) {
            return null;
        }
        try {
            return new PhotonFileMeta(response.getData());
        }
        catch (IOException e) {
            return null;
        }
    }

    public PhotonFilePreview getPreview(long offset) throws UnsupportedEncodingException {
        int length;
        PhotonFilePreview preview;
        if (this.folder) {
            return null;
        }
        long size = this.openFile();
        if (size != this.size) {
            return null;
        }
        DataTransferBlock response = this.readFromOffset(offset);
        if (response == null) {
            this.closeFile();
            return null;
        }
        if (!response.verifyChecksum()) {
            this.closeFile();
            return null;
        }
        try {
            preview = new PhotonFilePreview(response.getData());
        }
        catch (IOException e) {
            this.closeFile();
            return null;
        }
        byte[] data = new byte[(int)preview.getImgDataLength()];
        offset = preview.getImgDataOffset();
        for (int glide = 0; glide < data.length; glide += length) {
            response = this.readFromOffset(offset + (long)glide);
            if (response == null) {
                this.closeFile();
                return null;
            }
            if (!response.verifyChecksum()) {
                this.closeFile();
                return null;
            }
            length = response.getData().length;
            if (length > data.length - glide) {
                length = data.length - glide;
            }
            System.arraycopy(response.getData(), 0, data, glide, length);
        }
        this.closeFile();
        preview.addData(data);
        return preview;
    }

    private DataTransferBlock readNext() {
        NetRequestBinary data = new NetRequestBinary(this.io, "M3000");
        while (!data.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (data.getResponse() == null) {
            return null;
        }
        return new DataTransferBlock(data.getResponse());
    }

    private DataTransferBlock readFromOffset(long offset) {
        NetRequestBinary data = new NetRequestBinary(this.io, "M3001 I" + offset);
        while (!data.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (data.getResponse() == null) {
            return null;
        }
        return new DataTransferBlock(data.getResponse());
    }

    private long openFile() throws UnsupportedEncodingException {
        NetRegularCommand statusRequest = new NetRegularCommand(this.io, "M4000");
        while (!statusRequest.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (statusRequest.getResponse() == null) {
            return -1L;
        }
        Status stat = new Status();
        stat.update(statusRequest.getResponse());
        if (stat.getState() != Status.State.IDLE && stat.getState() != Status.State.FINISHED) {
            return -1L;
        }
        this.closeFile();
        NetRegularCommand fileRequest = new NetRegularCommand(this.io, "M6032 '" + this.name + "'");
        while (!fileRequest.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (fileRequest.getResponse() == null) {
            this.closeFile();
            return -1L;
        }
        return (long)Integer.parseInt(fileRequest.getResponse().split(":")[1]) & 0xFFFFFFFFL;
    }

    private void closeFile() throws UnsupportedEncodingException {
        NetRegularCommand closePrevious = new NetRegularCommand(this.io, "M22");
        while (!closePrevious.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void delete() throws UnsupportedEncodingException {
        NetRegularCommand delete = new NetRegularCommand(this.io, "M30 " + this.getFullPath());
        while (!delete.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void print() throws UnsupportedEncodingException {
        NetRegularCommand delete = new NetRegularCommand(this.io, "M6030 ':" + this.getFullPath() + "'");
    }

    public String toString() {
        return "FileListItem{baseDir='" + this.baseDir + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + ", folder=" + this.folder + '}';
    }
}

