/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Status {
    private static final Pattern pattern = Pattern.compile("B:\\d+/\\d+ E1:\\d+/\\d+ E2:\\d+/\\d+ X:\\d+.\\d+ Y:\\d+.\\d+ Z:(?<z>\\d+.\\d+) F:\\d+/\\d+ D:(?<current>\\d+)/(?<total>\\d+)/\\d+ T:(?<time>\\d+)");
    private static final Pattern filePattern = Pattern.compile("'(?<name>[^']+)'");
    private State state = State.UNKNOWN;
    private float progress = 0.0f;
    private int time = 0;
    private float z = 0.0f;
    private boolean updated = false;
    private String openedFile;

    public Status() {
    }

    public Status(String response) {
        this.update(response);
    }

    public void update(String response) {
        if (response == null) {
            return;
        }
        State oldState = this.state;
        float oldProgress = this.progress;
        int oldTime = this.time;
        float oldZ = this.z;
        Matcher m = pattern.matcher(response);
        while (m.find()) {
            if (m.groupCount() != 4) continue;
            this.z = Float.parseFloat(m.group("z"));
            float total = Float.parseFloat(m.group("total"));
            this.progress = total > 0.0f ? Float.parseFloat(m.group("current")) / total : 0.0f;
            this.time = Integer.parseInt(m.group("time"));
            if (this.time > 0) {
                this.state = State.PRINTING;
                continue;
            }
            if (this.state == State.PRINTING || this.state == State.FINISHED) {
                this.state = State.FINISHED;
                continue;
            }
            this.state = State.IDLE;
        }
        if (this.state != oldState) {
            this.updated = true;
        }
        if (this.progress != oldProgress) {
            this.updated = true;
        }
        if (this.time != oldTime) {
            this.updated = true;
        }
        if (this.z != oldZ) {
            this.updated = true;
        }
    }

    public void updateOpenedFile(String response) {
        if (response == null) {
            this.openedFile = null;
            return;
        }
        String oldFile = this.openedFile;
        Matcher m = filePattern.matcher(response);
        while (m.find()) {
            if (m.groupCount() != 1) continue;
            this.openedFile = m.group("name");
        }
        if (this.openedFile == null) {
            if (oldFile != null) {
                this.updated = true;
            }
        } else if (!this.openedFile.equals(oldFile)) {
            this.updated = true;
        }
    }

    public void setDisconnected() {
        this.state = State.OFFLINE;
        this.z = Float.NaN;
        this.progress = Float.NaN;
        this.time = 0;
        this.updated = true;
    }

    public boolean isUpdated() {
        boolean old = this.updated;
        this.updated = false;
        return old;
    }

    public void removePrint() {
        if (this.state == State.FINISHED) {
            this.state = State.IDLE;
        }
    }

    public State getState() {
        return this.state;
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTime() {
        return this.time;
    }

    public float getZ() {
        return this.z;
    }

    public String getOpenedFile() {
        return this.openedFile;
    }

    public String toString() {
        return "Status{state=" + (Object)((Object)this.state) + ", progress=" + this.progress + ", time=" + this.time + ", z=" + this.z + '}';
    }

    public static enum State {
        IDLE,
        PRINTING,
        FINISHED,
        OFFLINE,
        UNKNOWN;

    }
}

