/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.networkIO;

import de.sg_o.lib.photoNet.networkIO.NetRequestResponse;
import de.sg_o.lib.photoNet.networkIO.NetWorker;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class NetIO {
    InetAddress address;
    int port;
    private NetWorker worker;
    private Thread workerThread;
    private long counter = 0L;
    private long executed = -1L;

    public NetIO(InetAddress address, int port) throws SocketException {
        if (address == null) {
            throw new SocketException("Address Null");
        }
        this.address = address;
        this.port = port;
        this.start();
    }

    public NetIO(String address, int port) throws UnknownHostException, SocketException {
        this(InetAddress.getByName(address), port);
    }

    public void start() throws SocketException {
        if (this.isAlive()) {
            return;
        }
        this.counter = 0L;
        this.executed = -1L;
        this.worker = new NetWorker(this.address, this.port);
        this.workerThread = new Thread(this.worker);
        this.workerThread.start();
    }

    public NetRequestResponse send(byte[] data) {
        if (!this.isAlive()) {
            return null;
        }
        NetRequestResponse req = new NetRequestResponse(this.counter, data);
        ++this.counter;
        this.worker.addJob(req);
        return req;
    }

    public NetRequestResponse sendImmediately(byte[] data) {
        if (!this.isAlive()) {
            return null;
        }
        NetRequestResponse req = new NetRequestResponse(this.counter, data);
        ++this.counter;
        this.worker.addImportantJob(req);
        return req;
    }

    public boolean isAlive() {
        if (this.worker == null) {
            return false;
        }
        if (this.workerThread == null) {
            return false;
        }
        return this.workerThread.isAlive();
    }

    public long getLastExecuted() {
        while (this.worker.doneSize() > 0) {
            this.executed = this.worker.pollDone().getID();
        }
        return this.executed;
    }

    public long getCounter() {
        return this.counter;
    }

    public void stop() {
        this.worker.stop();
        while (this.workerThread.isAlive()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.worker = null;
        this.workerThread = null;
    }
}

