/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.photonFile;

import de.sg_o.lib.photoNet.photonFile.FileRead;
import java.io.IOException;

public class PhotonFileMeta {
    private final int fileVersion;
    private final float plateX;
    private final float plateY;
    private final float plateZ;
    private final float layerThickness;
    private final float normalExposureTime;
    private final float bottomExposureTime;
    private final float offTime;
    private final int bottomLayers;
    private final int screenHeight;
    private final int screenWidth;
    private final int lightCuringType;
    private final int nrLayers;
    private final long layerHeadersOffset;
    private final long previewHeaderOffset;
    private final long previewThumbnailHeaderOffset;
    private final int antiAliasing;

    public PhotonFileMeta(byte[] model) throws IOException {
        if (model == null) {
            throw new IOException("Input null");
        }
        if (model.length < 96) {
            throw new IOException("To Short");
        }
        int header = FileRead.readInt(model, 0);
        if (header != 318570521 && header != 419495186) {
            throw new IOException("Invalid Header");
        }
        this.fileVersion = FileRead.readInt(model, 4);
        this.plateX = FileRead.readFloat(model, 8);
        this.plateY = FileRead.readFloat(model, 12);
        this.plateZ = FileRead.readFloat(model, 16);
        this.layerThickness = FileRead.readFloat(model, 32);
        this.normalExposureTime = FileRead.readFloat(model, 36);
        this.bottomExposureTime = FileRead.readFloat(model, 40);
        this.offTime = FileRead.readFloat(model, 44);
        this.bottomLayers = FileRead.readInt(model, 48);
        this.screenHeight = FileRead.readInt(model, 52);
        this.screenWidth = FileRead.readInt(model, 56);
        this.previewHeaderOffset = (long)FileRead.readInt(model, 60) & 0xFFFFFFFFL;
        this.layerHeadersOffset = (long)FileRead.readInt(model, 64) & 0xFFFFFFFFL;
        this.nrLayers = FileRead.readInt(model, 68);
        this.previewThumbnailHeaderOffset = (long)FileRead.readInt(model, 72) & 0xFFFFFFFFL;
        this.lightCuringType = FileRead.readInt(model, 80);
        this.antiAliasing = FileRead.readInt(model, 92);
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public float getPlateX() {
        return this.plateX;
    }

    public float getPlateY() {
        return this.plateY;
    }

    public float getPlateZ() {
        return this.plateZ;
    }

    public float getLayerThickness() {
        return this.layerThickness;
    }

    public float getNormalExposureTime() {
        return this.normalExposureTime;
    }

    public float getBottomExposureTime() {
        return this.bottomExposureTime;
    }

    public float getOffTime() {
        return this.offTime;
    }

    public int getBottomLayers() {
        return this.bottomLayers;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getLightCuringType() {
        return this.lightCuringType;
    }

    public int getNrLayers() {
        return this.nrLayers;
    }

    public long getLayerHeadersOffset() {
        return this.layerHeadersOffset;
    }

    public long getPreviewHeaderOffset() {
        return this.previewHeaderOffset;
    }

    public long getPreviewThumbnailHeaderOffset() {
        return this.previewThumbnailHeaderOffset;
    }

    public long[] getLayers() {
        long[] allLayers = new long[this.nrLayers];
        for (int i = 0; i < allLayers.length; ++i) {
            allLayers[i] = this.layerHeadersOffset + (long)i * 36L;
        }
        return allLayers;
    }

    public String toString() {
        return "PhotonFileMeta{fileVersion=" + this.fileVersion + ", plateX=" + this.plateX + ", plateY=" + this.plateY + ", plateZ=" + this.plateZ + ", layerThickness=" + this.layerThickness + ", normalExposureTime=" + this.normalExposureTime + ", bottomExposureTime=" + this.bottomExposureTime + ", offTime=" + this.offTime + ", bottomLayers=" + this.bottomLayers + ", screenHeight=" + this.screenHeight + ", screenWidth=" + this.screenWidth + ", lightCuringType=" + this.lightCuringType + ", nrLayers=" + this.nrLayers + ", layerHeadersOffset=" + this.layerHeadersOffset + ", previewHeaderOffset=" + this.previewHeaderOffset + ", previewThumbnailHeaderOffset=" + this.previewThumbnailHeaderOffset + ", antiAliasing=" + this.antiAliasing + '}';
    }
}

