/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.photonFile;

import de.sg_o.lib.photoNet.photonFile.FileRead;
import de.sg_o.lib.photoNet.photonFile.PixelDataRGB;
import java.io.IOException;

public class PhotonFilePreview {
    private final int imgWidth;
    private final int imgHeight;
    private final long imgDataOffset;
    private final int imgDataLength;
    private final byte[] imgData;

    public PhotonFilePreview(byte[] model) throws IOException {
        if (model == null) {
            throw new IOException("Input null");
        }
        this.imgWidth = FileRead.readInt(model, 0);
        this.imgHeight = FileRead.readInt(model, 4);
        this.imgDataOffset = (long)FileRead.readInt(model, 8) & 0xFFFFFFFFL;
        this.imgDataLength = FileRead.readInt(model, 12);
        this.imgData = new byte[this.imgDataLength];
    }

    private static int[] decodeImage(byte[] data, int width, int height) {
        int max = width * height;
        int[] img = new int[max];
        int count = 0;
        for (int i = 0; i < data.length - 1; i += 2) {
            PixelDataRGB pixel = new PixelDataRGB(data[i], data[i + 1]);
            int repeat = 1;
            if (pixel.isMultiple() && (i += 2) < data.length - 1) {
                repeat += ((data[i + 1] & 0xFF) << 8 | data[i] & 0xFF) & 0xFFF;
            }
            for (int j = 0; j < repeat; ++j) {
                if (count >= max) {
                    return img;
                }
                img[count] = pixel.getRGB();
                ++count;
            }
        }
        return img;
    }

    public int getImgWidth() {
        return this.imgWidth;
    }

    public int getImgHeight() {
        return this.imgHeight;
    }

    public long getImgDataOffset() {
        return this.imgDataOffset;
    }

    public long getImgDataLength() {
        return this.imgDataLength;
    }

    public void addData(byte[] model) {
        System.arraycopy(model, 0, this.imgData, 0, this.imgData.length);
    }

    public int[] getImage() {
        return PhotonFilePreview.decodeImage(this.imgData, this.imgWidth, this.imgHeight);
    }

    public String toString() {
        return "PhotonFilePreview{imgWidth=" + this.imgWidth + ", imgHeight=" + this.imgHeight + ", imgDataOffset=" + this.imgDataOffset + ", imgDataLength=" + this.imgDataLength + '}';
    }
}

