/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.photonFile;

import de.sg_o.lib.photoNet.photonFile.FileRead;
import java.io.IOException;

public class PhotonLayer {
    private final float absolutePosition;
    private final float exposureTime;
    private final float offTime;
    private final long imgDataOffset;
    private final int imgDataLength;
    private final int screenWidth;
    private final int screenHeight;
    private byte[] imgData;

    public PhotonLayer(byte[] model, long index, int screenWidth, int screenHeight) throws IOException {
        if (model == null) {
            throw new IOException("File null");
        }
        this.absolutePosition = FileRead.readFloat(model, 0);
        this.exposureTime = FileRead.readFloat(model, 4);
        this.offTime = FileRead.readFloat(model, 8);
        this.imgDataOffset = (long)FileRead.readInt(model, 12) & 0xFFFFFFFFL;
        this.imgDataLength = FileRead.readInt(model, 16);
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    private static int[] decodeImage(byte[] data, int width, int height) {
        int max = width * height;
        int[] img = new int[max];
        int count = 0;
        for (byte datum : data) {
            int color = datum >> 7 & 1;
            int repeat = datum & 0x7F;
            for (int j = 0; j < repeat; ++j) {
                if (count >= max) {
                    return img;
                }
                img[count] = color * 255;
                ++count;
            }
        }
        System.out.println(max + ":" + count);
        return img;
    }

    public float getAbsolutePosition() {
        return this.absolutePosition;
    }

    public float getExposureTime() {
        return this.exposureTime;
    }

    public float getOffTime() {
        return this.offTime;
    }

    public long getImgDataOffset() {
        return this.imgDataOffset;
    }

    public int getImgDataLength() {
        return this.imgDataLength;
    }

    public void addData(byte[] model) {
        System.arraycopy(model, 0, this.imgData, 0, this.imgData.length);
    }

    public int[] getImage() {
        return PhotonLayer.decodeImage(this.imgData, this.screenWidth, this.screenHeight);
    }

    public String toString() {
        return "PhotonLayer{absolutePosition=" + this.absolutePosition + ", exposureTime=" + this.exposureTime + ", offTime=" + this.offTime + ", imgDataOffset=" + this.imgDataOffset + ", imgDataLength=" + this.imgDataLength + '}';
    }
}

