/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.photonFile;

public class PixelDataRGB {
    private static final int[] VALUE_MAP = new int[]{0, 8, 16, 25, 33, 41, 49, 58, 66, 74, 82, 90, 99, 107, 115, 123, 132, 140, 148, 156, 165, 173, 181, 189, 197, 206, 214, 222, 230, 239, 247, 255};
    private final int red;
    private final int green;
    private final int blue;
    private final boolean multiple;

    public PixelDataRGB(byte low, byte high) {
        int RGB = (high & 0xFF) << 8 | low & 0xFF;
        this.blue = RGB & 0x1F;
        this.multiple = (RGB & 0x20) > 0;
        this.green = RGB >> 6 & 0x1F;
        this.red = RGB >> 11 & 0x1F;
    }

    public int getRed() {
        return VALUE_MAP[this.red];
    }

    public int getGreen() {
        return VALUE_MAP[this.green];
    }

    public int getBlue() {
        return VALUE_MAP[this.blue];
    }

    public int getRGB() {
        return 0xFF000000 | (this.getRed() & 0xFF) << 16 | (this.getGreen() & 0xFF) << 8 | this.getBlue() & 0xFF;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public String toString() {
        return "PixelDataRGB{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + '}';
    }
}

