/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.printer;

import de.sg_o.lib.photoNet.netData.Status;
import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRegularCommand;
import java.io.UnsupportedEncodingException;

public class AsyncStatusUpdate
implements Runnable {
    private final NetIO io;
    private final Status status;
    private NetRegularCommand updateRequest;
    private NetRegularCommand selectedFileRequest;
    private int interval;
    private long lastUpdate = 0L;
    private boolean statusUpdated = false;
    private boolean fileUpdated = false;
    private int errorCount = 10;

    public AsyncStatusUpdate(int interval, Status status, NetIO io) {
        this.status = status;
        this.io = io;
        this.setUpdateInterval(interval);
    }

    @Override
    public void run() {
        while (this.interval > 1) {
            if (this.updateRequest != null) {
                if (!this.updateRequest.isExecuted()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (!this.statusUpdated) {
                    if (this.updateRequest.isError()) {
                        ++this.errorCount;
                        if (this.errorCount > 10) {
                            this.status.setDisconnected();
                            this.errorCount = 10;
                        }
                    } else {
                        this.errorCount = 0;
                        this.status.update(this.updateRequest.getResponse());
                        this.statusUpdated = true;
                    }
                }
            }
            if (this.selectedFileRequest != null) {
                if (!this.selectedFileRequest.isExecuted()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (!this.fileUpdated && !this.selectedFileRequest.isError()) {
                    this.status.updateOpenedFile(this.selectedFileRequest.getResponse());
                    this.fileUpdated = true;
                }
            }
            if (this.lastUpdate + (long)this.interval >= System.currentTimeMillis()) continue;
            try {
                this.updateRequest = new NetRegularCommand(this.io, "M4000");
                this.selectedFileRequest = new NetRegularCommand(this.io, "M4006");
                this.statusUpdated = false;
                this.fileUpdated = false;
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    public void setUpdateInterval(int interval) {
        if (interval < 1000) {
            interval = 1000;
        }
        if (interval > 600000) {
            interval = 600000;
        }
        this.interval = interval;
    }

    public void stop() {
        this.interval = -1;
    }
}

