/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.printer;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Discover
implements Runnable {
    private static final Pattern pattern = Pattern.compile("MAC:(?<mac>[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+) IP:(?<ip>\\d+.\\d+.\\d+.\\d+) VER:(?<ver>V[0-9.]+) ID:(?<id>[0-9a-fA-F,]+) NAME:(?<name>\\S+)");
    private final int timeout;
    private TreeMap<String, String> discovered;
    private Thread updateThread;

    public Discover(int timeout) {
        this.timeout = timeout;
    }

    private static List<InetAddress> listAllBroadcastAddresses() throws SocketException {
        ArrayList<InetAddress> broadcastList = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
            for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
                InetAddress broadcast;
                if (address == null || (broadcast = address.getBroadcast()) == null) continue;
                broadcastList.add(broadcast);
            }
        }
        return broadcastList;
    }

    public void update() {
        if (this.updateThread != null && this.updateThread.isAlive()) {
            return;
        }
        this.updateThread = new Thread(this);
        this.updateThread.start();
    }

    public boolean isValid() {
        if (this.discovered == null) {
            return false;
        }
        if (this.updateThread == null) {
            return false;
        }
        return !this.updateThread.isAlive();
    }

    public boolean isRunning() {
        if (this.updateThread == null) {
            return false;
        }
        return this.updateThread.isAlive();
    }

    @Override
    public void run() {
        try {
            this.discovered = new TreeMap();
            List<InetAddress> broadcasts = Discover.listAllBroadcastAddresses();
            for (InetAddress address : broadcasts) {
                DatagramSocket socket = new DatagramSocket();
                socket.setBroadcast(true);
                socket.setSoTimeout(this.timeout / 10 / broadcasts.size());
                String discover = "M99999";
                byte[] buffer = discover.getBytes();
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, 3000);
                try {
                    socket.send(packet);
                }
                catch (IOException e) {
                    continue;
                }
                long start = System.currentTimeMillis();
                byte[] buf = new byte[1024];
                while (start + (long)(this.timeout / broadcasts.size()) > System.currentTimeMillis()) {
                    String info;
                    DatagramPacket response = new DatagramPacket(buf, 0, buf.length);
                    try {
                        socket.receive(response);
                    }
                    catch (IOException e) {
                        continue;
                    }
                    if (response.getData() == null || response.getData().length < 64 || (info = new String(response.getData())).length() < 64) continue;
                    Matcher m = pattern.matcher(info);
                    while (m.find()) {
                        if (m.groupCount() != 5) continue;
                        this.discovered.put(response.getAddress().getHostAddress(), m.group("name"));
                    }
                }
                socket.close();
            }
        }
        catch (IOException ignored) {
            this.discovered = null;
        }
    }

    public TreeMap<String, String> getDiscovered() {
        return this.discovered;
    }
}

