/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import de.sg_o.lib.photoNet.netData.DataTransfer;
import de.sg_o.lib.photoNet.netData.DataTransferBlock;
import de.sg_o.lib.photoNet.netData.FileListItem;
import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRequestBinary;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class DataDownload
extends DataTransfer {
    private final FileListItem file;
    private final OutputStream dataStream;
    private final int maxRetries;
    private final long startOffset;
    private final NetIO io;
    private long glide = 0L;
    private int retries = 0;
    private long downloadLength;

    public DataDownload(FileListItem file, OutputStream dataStream, int maxRetries, long startOffset, long downloadLength, NetIO io) {
        this.file = file;
        this.dataStream = dataStream;
        if (maxRetries < 0) {
            maxRetries = 0;
        }
        this.maxRetries = maxRetries;
        if (startOffset < 0L) {
            startOffset = 0L;
        }
        this.startOffset = startOffset;
        this.downloadLength = downloadLength;
        this.io = io;
    }

    @Override
    public void run() {
        if (this.complete.get()) {
            return;
        }
        this.failed.set(false);
        this.running.set(true);
        try {
            if (this.file == null) {
                this.fail();
                return;
            }
            long size = this.file.openFile() - this.startOffset;
            if (size <= 0L) {
                this.fail();
                if (size == 0L) {
                    this.close();
                }
                return;
            }
            if (this.downloadLength < size && this.downloadLength > 0L) {
                size = this.downloadLength;
            } else {
                this.downloadLength = size;
            }
            while (this.glide < size) {
                if (this.aborted.get()) {
                    this.fail();
                    this.close();
                    return;
                }
                while (this.paused.get()) {
                    try {
                        if (this.aborted.get()) {
                            this.fail();
                            this.close();
                            return;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                DataTransferBlock response = this.readFromOffset(this.startOffset + this.glide);
                if (response == null) {
                    if (this.retries < this.maxRetries) {
                        ++this.retries;
                        continue;
                    }
                    this.fail();
                    this.close();
                    return;
                }
                if (!response.verifyChecksum()) {
                    if (this.retries < this.maxRetries) {
                        ++this.retries;
                        continue;
                    }
                    this.fail();
                    this.close();
                    return;
                }
                int length = response.getData().length;
                if ((long)length > size - this.glide) {
                    length = (int)(size - this.glide);
                }
                this.dataStream.write(response.getData(), 0, length);
                this.retries = 0;
                this.glide += (long)length;
            }
            this.dataStream.close();
            this.file.closeFile();
            this.complete.set(true);
            this.running.set(false);
        }
        catch (Exception e) {
            this.fail();
            this.close();
        }
    }

    private void fail() {
        this.failed.set(true);
        this.running.set(false);
    }

    private void close() {
        try {
            this.file.closeFile();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private DataTransferBlock readFromOffset(long offset) {
        NetRequestBinary data = new NetRequestBinary(this.io, "M3001 I" + offset);
        while (!data.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (data.getResponse() == null) {
            return null;
        }
        return new DataTransferBlock(data.getResponse());
    }

    @Override
    public boolean isComplete() {
        if (this.failed.get()) {
            return false;
        }
        return this.complete.get();
    }

    @Override
    public boolean hasFailed() {
        return this.failed.get();
    }

    @Override
    public float getProgress() {
        if (this.downloadLength < 1L) {
            return 0.0f;
        }
        return (float)this.glide / (float)this.downloadLength;
    }

    @Override
    public String getName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    @Override
    public boolean isPaused() {
        return this.paused.get();
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void abort() {
        this.aborted.set(true);
        this.end();
    }

    @Override
    public boolean isAborted() {
        return this.aborted.get();
    }

    @Override
    public void end() {
        try {
            this.dataStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "DataDownload{complete=" + this.complete + ", failed=" + this.failed + ", file='" + this.file + '\'' + ", maxRetries=" + this.maxRetries + ", startOffset=" + this.startOffset + ", downloadLength=" + this.downloadLength + '}';
    }
}

