/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import de.sg_o.lib.photoNet.netData.DataTransfer;
import de.sg_o.lib.photoNet.netData.DataTransferBlock;
import de.sg_o.lib.photoNet.netData.FileListItem;
import de.sg_o.lib.photoNet.netData.Status;
import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRegularCommand;
import de.sg_o.lib.photoNet.networkIO.NetSendBinary;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class DataUpload
extends DataTransfer {
    private static final int blockSize = 1280;
    private final FileListItem file;
    private final InputStream dataStream;
    private final int maxRetries;
    private final NetIO io;
    private int glide = 0;
    private int retries = 0;

    public DataUpload(FileListItem file, InputStream dataStream, int maxRetries, NetIO io) {
        this.file = file;
        this.dataStream = dataStream;
        if (maxRetries < 0) {
            maxRetries = 0;
        }
        this.maxRetries = maxRetries;
        this.io = io;
    }

    @Override
    public void run() {
        if (this.complete.get()) {
            return;
        }
        this.failed.set(false);
        this.running.set(true);
        try {
            int bytesRead;
            if (!this.createFile()) {
                this.fail();
                return;
            }
            if (this.dataStream == null) {
                this.fail();
                return;
            }
            byte[] buffer = new byte[1280];
            while ((bytesRead = this.dataStream.read(buffer, 0, buffer.length)) != -1) {
                if (this.aborted.get()) {
                    this.fail();
                    return;
                }
                while (this.paused.get()) {
                    try {
                        if (this.aborted.get()) {
                            this.fail();
                            return;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                byte[] toSend = buffer;
                if (bytesRead < buffer.length) {
                    toSend = new byte[bytesRead];
                    System.arraycopy(buffer, 0, toSend, 0, bytesRead);
                }
                if (!this.sendData(toSend, this.glide)) {
                    if (this.retries < this.maxRetries) {
                        ++this.retries;
                        continue;
                    }
                    this.fail();
                    return;
                }
                this.retries = 0;
                this.glide += bytesRead;
            }
            this.dataStream.close();
            this.endFile();
            this.complete.set(true);
            this.running.set(false);
        }
        catch (Exception e) {
            this.fail();
        }
    }

    private boolean sendData(byte[] data, int offset) {
        DataTransferBlock block = new DataTransferBlock(data, offset);
        NetSendBinary send = new NetSendBinary(this.io, block.generate());
        while (!send.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !send.isError();
    }

    private void fail() {
        this.failed.set(true);
        this.running.set(false);
        try {
            this.endFile();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private boolean createFile() throws UnsupportedEncodingException {
        if (this.file == null) {
            return false;
        }
        if (this.file.getName() == null) {
            return false;
        }
        if (this.file.getName().length() < 1) {
            return false;
        }
        NetRegularCommand statusRequest = new NetRegularCommand(this.io, "M4000");
        while (!statusRequest.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (statusRequest.getResponse() == null) {
            return false;
        }
        Status stat = new Status(statusRequest.getResponse());
        stat.update(statusRequest.getResponse());
        if (stat.getState() != Status.State.IDLE && stat.getState() != Status.State.FINISHED) {
            return false;
        }
        this.closeFile();
        NetRegularCommand fileRequest = new NetRegularCommand(this.io, "M28 " + this.file.getFullPath());
        while (!fileRequest.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    private void endFile() throws UnsupportedEncodingException {
        NetRegularCommand endFile = new NetRegularCommand(this.io, "M29");
        while (!endFile.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.closeFile();
    }

    private void closeFile() throws UnsupportedEncodingException {
        NetRegularCommand closeFile = new NetRegularCommand(this.io, "M22");
        while (!closeFile.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isComplete() {
        if (this.failed.get()) {
            return false;
        }
        return this.complete.get();
    }

    @Override
    public boolean hasFailed() {
        return this.failed.get();
    }

    @Override
    public float getProgress() {
        if (this.file.getSize() < 1L) {
            return 0.0f;
        }
        return (float)this.glide / (float)this.file.getSize();
    }

    @Override
    public String getName() {
        if (this.file == null) {
            return null;
        }
        return this.file.getName();
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void abort() {
        this.aborted.set(true);
        this.end();
    }

    @Override
    public boolean isAborted() {
        return this.aborted.get();
    }

    @Override
    public void end() {
        try {
            if (this.file != null) {
                this.file.closeFile();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String toString() {
        String sb = "DataUpload{complete=" + this.complete + ", failed=" + this.failed + ", file='" + this.file + '\'' + ", maxRetries=" + this.maxRetries + '}';
        return sb;
    }
}

