/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import de.sg_o.lib.photoNet.netData.DataDownload;
import de.sg_o.lib.photoNet.netData.DataUpload;
import de.sg_o.lib.photoNet.netData.Status;
import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRegularCommand;
import de.sg_o.lib.photoNet.photonFile.PhotonFileMeta;
import de.sg_o.lib.photoNet.photonFile.PhotonFilePreview;
import de.sg_o.lib.photoNet.printer.Folder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;

public class FileListItem {
    public static final String FOLDER_UP = "../";
    private final NetIO io;
    private final String baseDir;
    private final String name;
    private final long size;
    private final boolean folder;

    public FileListItem(String baseDir, String name, long size, boolean folder, NetIO io) {
        this.baseDir = baseDir;
        this.name = name;
        this.size = size;
        this.folder = folder;
        this.io = io;
    }

    public FileListItem(String baseDir, String info, NetIO io) {
        if (baseDir == null) {
            throw new InvalidParameterException("Null string");
        }
        this.baseDir = baseDir;
        if (info == null) {
            throw new InvalidParameterException("Null string");
        }
        if (info.length() < 1) {
            throw new InvalidParameterException("Couldn't parse String");
        }
        if (info.startsWith("->")) {
            this.folder = true;
            this.size = 0L;
            this.name = info.substring(2);
        } else {
            this.folder = false;
            String[] split = info.split("\\s+");
            if (split.length < 2) {
                throw new InvalidParameterException("Couldn't parse String");
            }
            this.size = Long.parseLong(split[split.length - 1]);
            this.name = info.substring(0, info.length() - split[split.length - 1].length()).trim();
        }
        this.io = io;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public Folder getFolder() {
        if (!this.isFolder()) {
            return null;
        }
        try {
            if (this.name.equals(FOLDER_UP)) {
                String[] split = this.baseDir.split("/");
                if (split.length < 2) {
                    return new Folder("", this.io);
                }
                StringBuilder parent = new StringBuilder();
                for (int i = 0; i < split.length - 1; ++i) {
                    if (i != 0) {
                        parent.append("/");
                    }
                    parent.append(split[i]);
                }
                return new Folder(parent.toString(), this.io);
            }
            return new Folder(this.getFullPath(), this.io);
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public String getFullPath() {
        if (this.baseDir.length() < 1) {
            return this.name;
        }
        return this.baseDir + "/" + this.name;
    }

    public PhotonFileMeta getMeta() {
        if (this.folder) {
            return null;
        }
        ByteArrayOutputStream meta = new ByteArrayOutputStream();
        DataDownload metaDownload = new DataDownload(this, meta, 2, 0L, 96L, this.io);
        metaDownload.run();
        if (!metaDownload.isComplete()) {
            return null;
        }
        if (meta.size() < 96) {
            return null;
        }
        try {
            return new PhotonFileMeta(meta.toByteArray());
        }
        catch (IOException e) {
            return null;
        }
    }

    public PhotonFilePreview getPreview(long offset) {
        PhotonFilePreview preview;
        if (this.folder) {
            return null;
        }
        ByteArrayOutputStream previewHeader = new ByteArrayOutputStream();
        DataDownload previewHeaderDownload = new DataDownload(this, previewHeader, 2, offset, 16L, this.io);
        previewHeaderDownload.run();
        if (!previewHeaderDownload.isComplete()) {
            return null;
        }
        if (previewHeader.size() < 16) {
            return null;
        }
        try {
            preview = new PhotonFilePreview(previewHeader.toByteArray());
        }
        catch (IOException e) {
            return null;
        }
        ByteArrayOutputStream previewData = new ByteArrayOutputStream();
        DataDownload previewDataDownload = new DataDownload(this, previewData, 2, preview.getImgDataOffset(), preview.getImgDataLength(), this.io);
        previewDataDownload.run();
        if (!previewHeaderDownload.isComplete()) {
            return null;
        }
        preview.addData(previewData.toByteArray());
        return preview;
    }

    public long openFile() throws UnsupportedEncodingException {
        NetRegularCommand statusRequest = new NetRegularCommand(this.io, "M4000");
        while (!statusRequest.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (statusRequest.getResponse() == null) {
            return -1L;
        }
        Status stat = new Status(statusRequest.getResponse());
        stat.update(statusRequest.getResponse());
        if (stat.getState() != Status.State.IDLE && stat.getState() != Status.State.FINISHED) {
            return -1L;
        }
        this.closeFile();
        NetRegularCommand fileRequest = new NetRegularCommand(this.io, "M6032 '" + this.name + "'");
        while (!fileRequest.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (fileRequest.getResponse() == null) {
            this.closeFile();
            return -1L;
        }
        return (long)Integer.parseInt(fileRequest.getResponse().split(":")[1]) & 0xFFFFFFFFL;
    }

    public void closeFile() throws UnsupportedEncodingException {
        NetRegularCommand closePrevious = new NetRegularCommand(this.io, "M22");
        while (!closePrevious.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public DataDownload getDownload(OutputStream dataStream, int maxRetries) {
        return new DataDownload(this, dataStream, maxRetries, 0L, 0L, this.io);
    }

    public DataUpload getUpload(InputStream dataStream, int maxRetries) {
        return new DataUpload(this, dataStream, maxRetries, this.io);
    }

    public void delete() throws UnsupportedEncodingException {
        NetRegularCommand delete = new NetRegularCommand(this.io, "M30 " + this.getFullPath());
        while (!delete.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void print() throws UnsupportedEncodingException {
        NetRegularCommand print = new NetRegularCommand(this.io, "M6030 ':" + this.getFullPath() + "'");
    }

    public String toString() {
        return "FileListItem{baseDir='" + this.baseDir + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + ", folder=" + this.folder + '}';
    }
}

