/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.netData;

import de.sg_o.lib.photoNet.netData.FileListItem;
import de.sg_o.lib.photoNet.networkIO.NetIO;
import java.util.TreeMap;

public class FolderList {
    private final TreeMap<String, FileListItem> items = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final String path;
    private final NetIO io;

    public FolderList(String path, String response, NetIO io) {
        FileListItem tmp;
        this.io = io;
        this.path = path;
        if (response == null) {
            return;
        }
        String[] lines = response.split("\\r?\\n");
        if (path != null && !path.equals("")) {
            tmp = new FileListItem(path, "../", 0L, true, io);
            this.items.put("-" + tmp.getName(), tmp);
        }
        for (int i = 1; i < lines.length - 2; ++i) {
            try {
                tmp = new FileListItem(path, lines[i], io);
                if (tmp.isFolder()) {
                    this.items.put("-" + tmp.getName(), tmp);
                    continue;
                }
                this.items.put(tmp.getName(), tmp);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public TreeMap<String, FileListItem> getItems() {
        return this.items;
    }

    public FileListItem newFile(String fileName, long size) {
        if (fileName == null) {
            return null;
        }
        if (fileName.length() < 1) {
            return null;
        }
        if (this.items.containsKey(fileName)) {
            return null;
        }
        return new FileListItem(this.path, fileName, size, false, this.io);
    }

    public String toString() {
        return "FolderList{path='" + this.path + '\'' + ", items=" + this.items + '}';
    }
}

