/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.networkIO;

import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRequestResponse;
import java.nio.charset.StandardCharsets;

public class NetRegularCommand {
    private final NetRequestResponse response;

    public NetRegularCommand(NetIO device, String command, boolean important) {
        byte[] com = command.trim().getBytes(StandardCharsets.US_ASCII);
        this.response = important ? device.sendImmediately(com) : device.send(com);
    }

    public NetRegularCommand(NetIO device, String command) {
        this(device, command, false);
    }

    public boolean isExecuted() {
        if (this.response == null) {
            return true;
        }
        if (this.response.getResponse() != null) {
            return true;
        }
        return this.response.getError() != null;
    }

    public boolean isError() {
        if (this.response == null) {
            return false;
        }
        return this.response.getError() != null;
    }

    public String getError() {
        if (!this.isExecuted()) {
            return null;
        }
        if (!this.isError()) {
            return null;
        }
        if (this.response == null) {
            return null;
        }
        return this.response.getError().trim();
    }

    public String getResponse() {
        if (!this.isExecuted()) {
            return null;
        }
        if (this.isError()) {
            return null;
        }
        if (this.response == null) {
            return null;
        }
        byte[] data = this.response.getResponse();
        if (data.length < 3) {
            return "";
        }
        return new String(data).trim();
    }
}

