/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.networkIO;

import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRequestResponse;

public class NetSendBinary {
    private final NetRequestResponse response;

    public NetSendBinary(NetIO device, byte[] data, boolean important) {
        this.response = important ? device.sendImmediately(data) : device.send(data);
    }

    public NetSendBinary(NetIO device, byte[] data) {
        this(device, data, false);
    }

    public boolean isExecuted() {
        if (this.response == null) {
            return true;
        }
        if (this.response.getResponse() != null) {
            return true;
        }
        return this.response.getError() != null;
    }

    public boolean isError() {
        if (this.response == null) {
            return false;
        }
        return this.response.getError() != null;
    }

    public String getError() {
        if (!this.isExecuted()) {
            return null;
        }
        if (!this.isError()) {
            return null;
        }
        if (this.response == null) {
            return null;
        }
        return this.response.getError().trim();
    }

    public String getResponse() {
        if (!this.isExecuted()) {
            return null;
        }
        if (this.isError()) {
            return null;
        }
        if (this.response == null) {
            return null;
        }
        byte[] data = this.response.getResponse();
        if (data.length < 3) {
            return "";
        }
        return new String(data).trim();
    }
}

