/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.networkIO;

import de.sg_o.lib.photoNet.networkIO.NetRequestResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.LinkedList;

public class NetWorker
implements Runnable {
    private final DatagramSocket socket;
    private final InetAddress address;
    private final int port;
    private final LinkedList<NetRequestResponse> toDo = new LinkedList();
    private final LinkedList<NetRequestResponse> done = new LinkedList();
    private final byte[] buf = new byte[2048];

    NetWorker(InetAddress address, int port, int timeout) throws SocketException {
        this.address = address;
        this.port = port;
        this.socket = new DatagramSocket();
        this.socket.setSoTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            NetRequestResponse active;
            int jobs;
            NetWorker netWorker = this;
            synchronized (netWorker) {
                jobs = this.toDo.size();
            }
            if (jobs < 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            NetWorker netWorker2 = this;
            synchronized (netWorker2) {
                active = this.toDo.poll();
            }
            if (active == null) continue;
            try {
                this.send(active);
            }
            catch (IOException e) {
                active.setError(e.getMessage());
                active.setResponse(null);
            }
            netWorker2 = this;
            synchronized (netWorker2) {
                this.done.add(active);
            }
        }
    }

    private void send(NetRequestResponse request) throws IOException {
        DatagramPacket packet = new DatagramPacket(request.getRequest(), request.getRequest().length, this.address, this.port);
        DatagramPacket response = new DatagramPacket(this.buf, 0, this.buf.length);
        this.socket.send(packet);
        byte[] multiPacket = null;
        while (true) {
            this.socket.receive(response);
            if (this.buf[0] == 111 && this.buf[1] == 107) {
                byte[] data;
                if (multiPacket == null) {
                    data = new byte[response.getLength() - 2];
                    System.arraycopy(this.buf, 2, data, 0, data.length);
                } else {
                    data = new byte[multiPacket.length + (response.getLength() - 2)];
                    System.arraycopy(multiPacket, 0, data, 0, multiPacket.length);
                    System.arraycopy(this.buf, 2, data, multiPacket.length, response.getLength() - 2);
                }
                request.setResponse(data);
                return;
            }
            if (this.buf[0] == 69 && this.buf[1] == 114 && this.buf[2] == 114 && this.buf[3] == 111 && this.buf[4] == 114 && (this.buf[5] == 58 || this.buf[5] == 44)) {
                byte[] data = new byte[response.getLength() - 6];
                System.arraycopy(this.buf, 6, data, 0, data.length);
                request.setError(new String(data));
                request.setResponse(null);
                return;
            }
            if (response.getLength() != 17 && multiPacket == null && !new String(this.buf).trim().startsWith("Begin file list")) {
                byte[] data = new byte[response.getLength()];
                System.arraycopy(this.buf, 0, data, 0, data.length);
                request.setResponse(data);
                return;
            }
            int destPos = 0;
            if (multiPacket == null) {
                multiPacket = new byte[response.getLength()];
            } else {
                byte[] tmp = multiPacket;
                destPos = tmp.length;
                multiPacket = new byte[tmp.length + response.getLength()];
                System.arraycopy(tmp, 0, multiPacket, 0, tmp.length);
            }
            System.arraycopy(this.buf, 0, multiPacket, destPos, response.getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addJob(NetRequestResponse job) {
        NetWorker netWorker = this;
        synchronized (netWorker) {
            this.toDo.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addImportantJob(NetRequestResponse job) {
        NetWorker netWorker = this;
        synchronized (netWorker) {
            this.toDo.addFirst(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doneSize() {
        int size;
        NetWorker netWorker = this;
        synchronized (netWorker) {
            size = this.done.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NetRequestResponse pollDone() {
        NetRequestResponse job;
        NetWorker netWorker = this;
        synchronized (netWorker) {
            job = this.done.poll();
        }
        return job;
    }

    void stop() {
        this.socket.close();
    }
}

