/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.printer;

import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRegularCommand;
import de.sg_o.lib.photoNet.printer.Printer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AsyncPrinterInformation
implements Runnable {
    private static final Pattern pattern = Pattern.compile("MAC:(?<mac>[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+) IP:(?<ip>\\d+.\\d+.\\d+.\\d+) VER:(?<ver>V[0-9.]+) ID:(?<id>[0-9a-fA-F,]+) NAME:(?<name>\\S+)");
    private final NetIO io;
    private final Printer p;

    public AsyncPrinterInformation(Printer p, NetIO io) {
        this.p = p;
        this.io = io;
    }

    @Override
    public void run() {
        NetRegularCommand statusRequest = new NetRegularCommand(this.io, "M99999");
        while (!statusRequest.isExecuted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        String response = statusRequest.getResponse();
        if (response == null) {
            return;
        }
        Matcher m = pattern.matcher(response);
        while (m.find()) {
            if (m.groupCount() != 5) continue;
            String mac = m.group("mac");
            String ver = m.group("ver");
            String id = m.group("id");
            String name = m.group("name");
            this.p.populateInformation(name, ver, mac, id);
        }
    }
}

