/*
 * Decompiled with CFR 0.152.
 */
package de.sg_o.lib.photoNet.printer;

import de.sg_o.lib.photoNet.netData.Status;
import de.sg_o.lib.photoNet.networkIO.NetIO;
import de.sg_o.lib.photoNet.networkIO.NetRegularCommand;
import de.sg_o.lib.photoNet.printer.AsyncPrinterInformation;
import de.sg_o.lib.photoNet.printer.AsyncStatusUpdate;
import de.sg_o.lib.photoNet.printer.RootFolder;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Printer {
    private final NetIO io;
    private final Status status = new Status();
    private final AsyncStatusUpdate statUpdate;
    private final Thread statUpdateThread;
    private final String ip;
    private final RootFolder rootFolder;
    private String name;
    private String ver;
    private String mac;
    private String id;

    public Printer(String ip, int timeout) throws SocketException, UnknownHostException, UnsupportedEncodingException {
        this.ip = ip;
        this.io = new NetIO(ip, 3000, timeout);
        AsyncPrinterInformation info = new AsyncPrinterInformation(this, this.io);
        Thread infoThread = new Thread(info);
        infoThread.start();
        this.statUpdate = new AsyncStatusUpdate(5000, this.status, this.io);
        this.statUpdateThread = new Thread(this.statUpdate);
        this.statUpdateThread.start();
        this.rootFolder = new RootFolder(this.io);
    }

    void populateInformation(String name, String ver, String mac, String id) {
        this.name = name;
        this.ver = ver;
        this.mac = mac;
        this.id = id;
    }

    public Status getStatus() {
        return this.status;
    }

    public RootFolder getRootFolder() {
        return this.rootFolder;
    }

    public void setStatusUpdateInterval(int interval) {
        this.statUpdate.setUpdateInterval(interval);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (name.length() < 1) {
            return;
        }
        if (name.length() > 15) {
            return;
        }
        this.name = name;
        NetRegularCommand rename = new NetRegularCommand(this.io, "U100 '" + name + "'");
    }

    public String getIp() {
        return this.ip;
    }

    public String getVer() {
        return this.ver;
    }

    public String getMac() {
        return this.mac;
    }

    public String getId() {
        return this.id;
    }

    public void disconnect() {
        this.statUpdate.stop();
        while (this.statUpdateThread.isAlive()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.io.stop();
    }

    public String toString() {
        return "Printer{name='" + this.name + '\'' + ", ip='" + this.ip + '\'' + ", ver='" + this.ver + '\'' + ", mac='" + this.mac + '\'' + ", id='" + this.id + '\'' + '}';
    }
}

