/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.crypto;

import de.slackspace.openkeepass.crypto.Aes;
import de.slackspace.openkeepass.crypto.Sha256;
import de.slackspace.openkeepass.domain.KeePassHeader;
import de.slackspace.openkeepass.util.StreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Decrypter {
    public byte[] decryptDatabase(byte[] password, KeePassHeader header, byte[] database) throws IOException {
        byte[] aesKey = this.createAesKey(password, header);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(database));
        bufferedInputStream.skip(12 + header.getHeaderSize());
        byte[] payload = StreamUtils.toByteArray(bufferedInputStream);
        return Aes.decrypt(aesKey, header.getEncryptionIV(), payload);
    }

    private byte[] createAesKey(byte[] password, KeePassHeader header) {
        byte[] hashedPwd = Sha256.hash(password);
        byte[] transformedPwd = Aes.transformKey(header.getTransformSeed(), hashedPwd, header.getTransformRounds());
        byte[] transformedHashedPwd = Sha256.hash(transformedPwd);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(header.getMasterSeed(), 0, 32);
        stream.write(transformedHashedPwd, 0, 32);
        byte[] aesKey = Sha256.hash(stream.toByteArray());
        return aesKey;
    }
}

