/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.crypto;

import de.slackspace.openkeepass.crypto.ProtectedStringCrypto;
import de.slackspace.openkeepass.crypto.Sha256;
import java.io.UnsupportedEncodingException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class Salsa20
implements ProtectedStringCrypto {
    private static final String SALSA20IV = "E830094B97205D2A";
    private Salsa20Engine salsa20Engine;

    private Salsa20() {
    }

    private void initialize(byte[] protectedStreamKey) {
        byte[] salsaKey = Sha256.hash(protectedStreamKey);
        this.salsa20Engine = new Salsa20Engine();
        this.salsa20Engine.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(salsaKey), Hex.decode((String)SALSA20IV)));
    }

    public static Salsa20 createInstance(byte[] protectedStreamKey) {
        if (protectedStreamKey == null) {
            throw new IllegalArgumentException("ProtectedStreamKey must not be null");
        }
        Salsa20 salsa20 = new Salsa20();
        salsa20.initialize(protectedStreamKey);
        return salsa20;
    }

    @Override
    public String decrypt(String protectedString) {
        if (protectedString == null) {
            throw new IllegalArgumentException("ProtectedString must not be null");
        }
        byte[] protectedBuffer = Base64.decode((byte[])protectedString.getBytes());
        byte[] plainText = new byte[protectedBuffer.length];
        this.salsa20Engine.processBytes(protectedBuffer, 0, protectedBuffer.length, plainText, 0);
        try {
            return new String(plainText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("The encoding UTF-8 is not supported");
        }
    }
}

