/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.KeePassFileElement;
import de.slackspace.openkeepass.domain.Property;
import de.slackspace.openkeepass.domain.PropertyValue;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Entry
implements KeePassFileElement {
    private static final String USER_NAME = "UserName";
    private static final String NOTES = "Notes";
    private static final String URL = "URL";
    private static final String PASSWORD = "Password";
    private static final String TITLE = "Title";
    @XmlTransient
    private KeePassFileElement parent;
    @XmlElement(name="UUID")
    private String uuid;
    @XmlElement(name="String")
    private Set<Property> properties = new HashSet<Property>();

    Entry() {
    }

    public Entry(String uuid) {
        this.setUuid(uuid);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public String getTitle() {
        return this.getValueFromProperty(TITLE);
    }

    public void setTitle(String title) {
        this.setValue(TITLE, title);
    }

    public String getPassword() {
        return this.getValueFromProperty(PASSWORD);
    }

    public void setPassword(String password) {
        this.setValue(PASSWORD, password);
    }

    public String getUrl() {
        return this.getValueFromProperty(URL);
    }

    public void setUrl(String url) {
        this.setValue(URL, url);
    }

    public String getNotes() {
        return this.getValueFromProperty(NOTES);
    }

    public void setNotes(String notes) {
        this.setValue(NOTES, notes);
    }

    public String getUsername() {
        return this.getValueFromProperty(USER_NAME);
    }

    public void setUsername(String username) {
        this.setValue(USER_NAME, username);
    }

    public boolean isTitleProtected() {
        return this.getPropertyByName(TITLE).isProtected();
    }

    public boolean isPasswordProtected() {
        return this.getPropertyByName(PASSWORD).isProtected();
    }

    public void setParent(KeePassFileElement element) {
        this.parent = element;
        for (Property property : this.properties) {
            property.setParent(this);
        }
    }

    private void setValue(String propertyName, String propertyValue) {
        Property property = this.getPropertyByName(propertyName);
        if (property == null) {
            property = new Property(propertyName, propertyValue, false);
            this.properties.add(property);
        } else {
            property.setValue(new PropertyValue(false, propertyValue));
        }
    }

    private String getValueFromProperty(String name) {
        Property property = this.getPropertyByName(name);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    private Property getPropertyByName(String name) {
        for (Property property : this.properties) {
            if (!property.getKey().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }
}

