/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.crypto.ProtectedStringCrypto;
import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.KeePassFileElement;
import de.slackspace.openkeepass.domain.Meta;
import de.slackspace.openkeepass.filter.Filter;
import de.slackspace.openkeepass.filter.ListFilter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class KeePassFile
implements KeePassFileElement {
    @XmlElement(name="Meta")
    private Meta meta;
    @XmlElement(name="Root")
    private Group root;
    @XmlTransient
    private ProtectedStringCrypto protectedStringCrypto;

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public Group getRoot() {
        return this.root;
    }

    public void setRoot(Group root) {
        this.root = root;
    }

    public List<Group> getTopGroups() {
        if (this.root != null && this.root.getGroups() != null && this.root.getGroups().size() == 1) {
            return this.root.getGroups().get(0).getGroups();
        }
        return new ArrayList<Group>();
    }

    public List<Entry> getTopEntries() {
        if (this.root != null && this.root.getGroups() != null && this.root.getGroups().size() == 1) {
            return this.root.getGroups().get(0).getEntries();
        }
        return new ArrayList<Entry>();
    }

    public Entry getEntryByTitle(String title) {
        List<Entry> entries = this.getEntriesByTitle(title, true);
        if (entries != null) {
            return entries.get(0);
        }
        return null;
    }

    public List<Entry> getEntriesByTitle(final String title, final boolean matchExactly) {
        ArrayList<Entry> allEntries = new ArrayList<Entry>();
        if (this.root != null) {
            this.getEntries(this.root, allEntries);
        }
        return ListFilter.filter(allEntries, new Filter<Entry>(){

            @Override
            public boolean matches(Entry item) {
                return matchExactly ? item.getTitle() != null && item.getTitle().equalsIgnoreCase(title) : item.getTitle() != null && item.getTitle().contains(title);
            }
        });
    }

    public void init() {
        this.root.setParent(this);
    }

    public List<Entry> getEntries() {
        ArrayList<Entry> allEntries = new ArrayList<Entry>();
        if (this.root != null) {
            this.getEntries(this.root, allEntries);
        }
        return allEntries;
    }

    private void getEntries(Group parentGroup, List<Entry> entries) {
        List<Group> groups = parentGroup.getGroups();
        entries.addAll(parentGroup.getEntries());
        if (groups.size() != 0) {
            for (Group group : groups) {
                this.getEntries(group, entries);
            }
        }
    }
}

