/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass;

import de.slackspace.openkeepass.crypto.Decrypter;
import de.slackspace.openkeepass.crypto.Salsa20;
import de.slackspace.openkeepass.crypto.Sha256;
import de.slackspace.openkeepass.domain.CompressionAlgorithm;
import de.slackspace.openkeepass.domain.CrsAlgorithm;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.KeePassHeader;
import de.slackspace.openkeepass.domain.KeyFile;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnreadable;
import de.slackspace.openkeepass.parser.KeePassDatabaseXmlParser;
import de.slackspace.openkeepass.parser.KeyFileXmlParser;
import de.slackspace.openkeepass.stream.HashedBlockInputStream;
import de.slackspace.openkeepass.util.ByteUtils;
import de.slackspace.openkeepass.util.StreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.bouncycastle.util.encoders.Base64;

public class KeePassDatabase {
    private static final int DATABASE_V2_FILE_SIGNATURE_1 = 3;
    private static final int DATABASE_V2_FILE_SIGNATURE_2 = 103;
    private static final int OLD_DATABASE_V1_FILE_SIGNATURE_1 = 3;
    private static final int OLD_DATABASE_V1_FILE_SIGNATURE_2 = 101;
    public static final int VERSION_SIGNATURE_LENGTH = 12;
    private KeePassHeader keepassHeader = new KeePassHeader();
    private byte[] keepassFile;
    protected Decrypter decrypter = new Decrypter();
    protected KeePassDatabaseXmlParser keePassDatabaseXmlParser = new KeePassDatabaseXmlParser();
    protected KeyFileXmlParser keyFileXmlParser = new KeyFileXmlParser();

    private KeePassDatabase(InputStream inputStream) {
        try {
            this.keepassFile = StreamUtils.toByteArray(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeePassDatabase getInstance(String keePassDatabaseFile) {
        return KeePassDatabase.getInstance(new File(keePassDatabaseFile));
    }

    public static KeePassDatabase getInstance(File keePassDatabaseFile) {
        if (keePassDatabaseFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass database file.");
        }
        try {
            return KeePassDatabase.getInstance(new FileInputStream(keePassDatabaseFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass database file could not be found. You must provide a valid KeePass database file.");
        }
    }

    public static KeePassDatabase getInstance(InputStream keePassDatabaseStream) {
        if (keePassDatabaseStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass database stream.");
        }
        KeePassDatabase reader = new KeePassDatabase(keePassDatabaseStream);
        try {
            reader.checkVersionSupport();
            reader.readHeader();
            return reader;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read input stream", e);
        }
    }

    private void checkVersionSupport() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.keepassFile));
        byte[] signature = new byte[12];
        bufferedInputStream.read(signature);
        ByteBuffer signatureBuffer = ByteBuffer.wrap(signature);
        signatureBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int signaturePart1 = ByteUtils.toUnsignedInt(signatureBuffer.getInt());
        int signaturePart2 = ByteUtils.toUnsignedInt(signatureBuffer.getInt());
        if (signaturePart1 == 3 && signaturePart2 == 103) {
            return;
        }
        if (signaturePart1 == 3 && signaturePart2 == 101) {
            throw new UnsupportedOperationException("The provided KeePass database file seems to be from KeePass 1.x which is not supported!");
        }
        throw new UnsupportedOperationException("The provided file seems to be no KeePass database file!");
    }

    private void readHeader() throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.keepassFile));
        bufferedInputStream.skip(12L);
        try {
            int fieldId;
            do {
                fieldId = bufferedInputStream.read();
                byte[] fieldLength = new byte[2];
                bufferedInputStream.read(fieldLength);
                ByteBuffer fieldLengthBuffer = ByteBuffer.wrap(fieldLength);
                fieldLengthBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int fieldLengthInt = ByteUtils.toUnsignedInt(fieldLengthBuffer.getShort());
                if (fieldLengthInt <= 0) continue;
                byte[] data = new byte[fieldLengthInt];
                bufferedInputStream.read(data);
                this.keepassHeader.setValue(fieldId, data);
                this.keepassHeader.increaseHeaderSize(fieldLengthInt + 3);
            } while (fieldId != 0);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read header input", e);
        }
    }

    public KeePassFile openDatabase(String password) {
        if (password == null) {
            throw new IllegalArgumentException("The password for the database must not be null. Please provide a valid password.");
        }
        try {
            byte[] passwordBytes = password.getBytes("UTF-8");
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            return this.decryptAndParseDatabase(hashedPassword);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("The encoding UTF-8 is not supported");
        }
    }

    public KeePassFile openDatabase(File keyFile) {
        if (keyFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass keyfile.");
        }
        try {
            return this.openDatabase(new FileInputStream(keyFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass keyfile could not be found. You must provide a valid KeePass keyfile.");
        }
    }

    public KeePassFile openDatabase(InputStream keyFileStream) {
        if (keyFileStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass keyfile stream.");
        }
        try {
            KeyFile keyFile = this.keyFileXmlParser.parse(keyFileStream);
            byte[] protectedBuffer = Base64.decode((byte[])keyFile.getKey().getData().getBytes("UTF-8"));
            return this.decryptAndParseDatabase(protectedBuffer);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("The encoding UTF-8 is not supported");
        }
    }

    private KeePassFile decryptAndParseDatabase(byte[] key) {
        try {
            byte[] hashedBlockBytes;
            byte[] aesDecryptedDbFile = this.decrypter.decryptDatabase(key, this.keepassHeader, this.keepassFile);
            byte[] startBytes = new byte[32];
            ByteArrayInputStream decryptedStream = new ByteArrayInputStream(aesDecryptedDbFile);
            decryptedStream.read(startBytes);
            if (!Arrays.equals(this.keepassHeader.getStreamStartBytes(), startBytes)) {
                throw new KeePassDatabaseUnreadable("The keepass database file seems to be corrupt or cannot be decrypted.");
            }
            HashedBlockInputStream hashedBlockInputStream = new HashedBlockInputStream(decryptedStream);
            byte[] decompressed = hashedBlockBytes = StreamUtils.toByteArray(hashedBlockInputStream);
            if (this.keepassHeader.getCompression().equals((Object)CompressionAlgorithm.Gzip)) {
                GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(hashedBlockBytes));
                decompressed = StreamUtils.toByteArray(gzipInputStream);
            }
            if (!this.keepassHeader.getCrsAlgorithm().equals((Object)CrsAlgorithm.Salsa20)) {
                throw new UnsupportedOperationException("Only Salsa20 is supported as CrsAlgorithm at the moment!");
            }
            Salsa20 protectedStringCrypto = Salsa20.createInstance(this.keepassHeader.getProtectedStreamKey());
            return this.keePassDatabaseXmlParser.parse(new ByteArrayInputStream(decompressed), protectedStringCrypto);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open database file", e);
        }
    }

    public KeePassHeader getHeader() {
        return this.keepassHeader;
    }
}

