/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.CompressionAlgorithm;
import de.slackspace.openkeepass.domain.CrsAlgorithm;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class KeePassHeader {
    private int headerSize = 0;
    private byte[] cipher;
    private byte[] encryptionIV;
    private byte[] streamStartBytes;
    private byte[] masterSeed;
    private byte[] transformSeed;
    private byte[] protectedStreamKey;
    private CompressionAlgorithm compression;
    private long transformRounds;
    private CrsAlgorithm crsAlgorithm;

    public void setValue(int headerId, byte[] value) {
        switch (headerId) {
            case 2: {
                this.setCipher(value);
                break;
            }
            case 3: {
                this.setCompressionFlag(value);
                break;
            }
            case 4: {
                this.setMasterSeed(value);
                break;
            }
            case 5: {
                this.setTransformSeed(value);
                break;
            }
            case 6: {
                this.setTransformRounds(value);
                break;
            }
            case 7: {
                this.setEncryptionIV(value);
                break;
            }
            case 8: {
                this.setProtectedStreamKey(value);
                break;
            }
            case 9: {
                this.setStreamStartBytes(value);
                break;
            }
            case 10: {
                this.setInnerRandomStreamId(value);
            }
        }
    }

    private void setInnerRandomStreamId(byte[] value) {
        ByteBuffer buffer = this.wrapInBuffer(value);
        int intValue = buffer.getInt();
        this.crsAlgorithm = CrsAlgorithm.parseValue(intValue);
    }

    private void setStreamStartBytes(byte[] value) {
        this.streamStartBytes = value;
    }

    private void setProtectedStreamKey(byte[] value) {
        this.protectedStreamKey = value;
    }

    private void setEncryptionIV(byte[] value) {
        this.encryptionIV = value;
    }

    private void setTransformRounds(byte[] value) {
        ByteBuffer buffer = this.wrapInBuffer(value);
        this.transformRounds = buffer.getLong();
    }

    private void setTransformSeed(byte[] value) {
        this.transformSeed = value;
    }

    private void setMasterSeed(byte[] value) {
        this.masterSeed = value;
    }

    private void setCompressionFlag(byte[] value) {
        ByteBuffer buffer = this.wrapInBuffer(value);
        int intValue = buffer.getInt();
        this.compression = CompressionAlgorithm.parseValue(intValue);
    }

    private void setCipher(byte[] value) {
        if (value == null || value.length != 16) {
            throw new IllegalArgumentException("The encryption cipher must contain 16 bytes!");
        }
        this.cipher = value;
    }

    public byte[] getCipher() {
        return this.cipher;
    }

    public CompressionAlgorithm getCompression() {
        return this.compression;
    }

    public long getTransformRounds() {
        return this.transformRounds;
    }

    public byte[] getEncryptionIV() {
        return this.encryptionIV;
    }

    public byte[] getStreamStartBytes() {
        return this.streamStartBytes;
    }

    public CrsAlgorithm getCrsAlgorithm() {
        return this.crsAlgorithm;
    }

    public byte[] getMasterSeed() {
        return this.masterSeed;
    }

    public byte[] getTransformSeed() {
        return this.transformSeed;
    }

    public void increaseHeaderSize(int numBytes) {
        this.headerSize += numBytes;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public byte[] getProtectedStreamKey() {
        return this.protectedStreamKey;
    }

    private ByteBuffer wrapInBuffer(byte[] value) {
        ByteBuffer buffer = ByteBuffer.wrap(value);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }
}

