/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.parser;

import de.slackspace.openkeepass.crypto.ProtectedStringCrypto;
import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.History;
import de.slackspace.openkeepass.domain.KeePassFile;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXB;

public class KeePassDatabaseXmlParser {
    public KeePassFile parse(InputStream inputStream, ProtectedStringCrypto protectedStringCrypto) {
        KeePassFile keePassFile = (KeePassFile)JAXB.unmarshal((InputStream)inputStream, KeePassFile.class);
        keePassFile.init();
        List<Entry> entries = keePassFile.getEntries();
        for (Entry entry : entries) {
            this.decryptAndSetPassword(entry, protectedStringCrypto);
            History history = entry.getHistory();
            for (Entry historicEntry : history.getHistoricEntries()) {
                this.decryptAndSetPassword(historicEntry, protectedStringCrypto);
            }
        }
        return keePassFile;
    }

    private void decryptAndSetPassword(Entry entry, ProtectedStringCrypto protectedStringCrypto) {
        if (entry != null && !entry.getPassword().isEmpty() && entry.isPasswordProtected()) {
            String decrypted = protectedStringCrypto.decrypt(entry.getPassword());
            entry.setPassword(decrypted);
        }
    }
}

