/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass;

import de.slackspace.openkeepass.crypto.Decrypter;
import de.slackspace.openkeepass.crypto.Salsa20;
import de.slackspace.openkeepass.crypto.Sha256;
import de.slackspace.openkeepass.domain.CompressionAlgorithm;
import de.slackspace.openkeepass.domain.CrsAlgorithm;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.KeePassHeader;
import de.slackspace.openkeepass.domain.KeyFile;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnreadable;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnwriteable;
import de.slackspace.openkeepass.stream.HashedBlockInputStream;
import de.slackspace.openkeepass.stream.HashedBlockOutputStream;
import de.slackspace.openkeepass.util.StreamUtils;
import de.slackspace.openkeepass.xml.KeePassDatabaseXmlParser;
import de.slackspace.openkeepass.xml.KeyFileXmlParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.util.encoders.Base64;

public class KeePassDatabase {
    private KeePassHeader keepassHeader = new KeePassHeader();
    private byte[] keepassFile;
    protected Decrypter decrypter = new Decrypter();
    protected KeePassDatabaseXmlParser keePassDatabaseXmlParser = new KeePassDatabaseXmlParser();
    protected KeyFileXmlParser keyFileXmlParser = new KeyFileXmlParser();

    private KeePassDatabase(InputStream inputStream) {
        try {
            this.tryAvoidJCE();
            this.keepassFile = StreamUtils.toByteArray(inputStream);
            this.keepassHeader.checkVersionSupport(this.keepassFile);
            this.keepassHeader.read(this.keepassFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tryAvoidJCE() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            field.set(null, Boolean.FALSE);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static KeePassDatabase getInstance(String keePassDatabaseFile) {
        return KeePassDatabase.getInstance(new File(keePassDatabaseFile));
    }

    public static KeePassDatabase getInstance(File keePassDatabaseFile) {
        if (keePassDatabaseFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass database file.");
        }
        FileInputStream keePassDatabaseStream = null;
        try {
            keePassDatabaseStream = new FileInputStream(keePassDatabaseFile);
            KeePassDatabase keePassDatabase = KeePassDatabase.getInstance(keePassDatabaseStream);
            return keePassDatabase;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass database file could not be found. You must provide a valid KeePass database file.");
        }
        finally {
            if (keePassDatabaseStream != null) {
                try {
                    ((InputStream)keePassDatabaseStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static KeePassDatabase getInstance(InputStream keePassDatabaseStream) {
        if (keePassDatabaseStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass database stream.");
        }
        KeePassDatabase reader = new KeePassDatabase(keePassDatabaseStream);
        return reader;
    }

    public KeePassFile openDatabase(String password) {
        if (password == null) {
            throw new IllegalArgumentException("The password for the database must not be null. Please provide a valid password.");
        }
        try {
            byte[] passwordBytes = password.getBytes("UTF-8");
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            return this.decryptAndParseDatabase(hashedPassword);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("The encoding UTF-8 is not supported");
        }
    }

    public KeePassFile openDatabase(File keyFile) {
        if (keyFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass keyfile.");
        }
        try {
            return this.openDatabase(new FileInputStream(keyFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass keyfile could not be found. You must provide a valid KeePass keyfile.");
        }
    }

    public KeePassFile openDatabase(InputStream keyFileStream) {
        if (keyFileStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass keyfile stream.");
        }
        try {
            KeyFile keyFile = this.keyFileXmlParser.fromXml(keyFileStream);
            byte[] protectedBuffer = Base64.decode((byte[])keyFile.getKey().getData().getBytes("UTF-8"));
            return this.decryptAndParseDatabase(protectedBuffer);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("The encoding UTF-8 is not supported");
        }
    }

    private KeePassFile decryptAndParseDatabase(byte[] key) {
        try {
            byte[] hashedBlockBytes;
            byte[] aesDecryptedDbFile = this.decrypter.decryptDatabase(key, this.keepassHeader, this.keepassFile);
            byte[] startBytes = new byte[32];
            ByteArrayInputStream decryptedStream = new ByteArrayInputStream(aesDecryptedDbFile);
            decryptedStream.skip(12 + this.keepassHeader.getHeaderSize());
            decryptedStream.read(startBytes);
            if (!Arrays.equals(this.keepassHeader.getStreamStartBytes(), startBytes)) {
                throw new KeePassDatabaseUnreadable("The keepass database file seems to be corrupt or cannot be decrypted.");
            }
            HashedBlockInputStream hashedBlockInputStream = new HashedBlockInputStream(decryptedStream);
            byte[] decompressed = hashedBlockBytes = StreamUtils.toByteArray(hashedBlockInputStream);
            if (this.keepassHeader.getCompression().equals((Object)CompressionAlgorithm.Gzip)) {
                GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(hashedBlockBytes));
                decompressed = StreamUtils.toByteArray(gzipInputStream);
            }
            if (!this.keepassHeader.getCrsAlgorithm().equals((Object)CrsAlgorithm.Salsa20)) {
                throw new UnsupportedOperationException("Only Salsa20 is supported as CrsAlgorithm at the moment!");
            }
            Salsa20 protectedStringCrypto = Salsa20.createInstance(this.keepassHeader.getProtectedStreamKey());
            return this.keePassDatabaseXmlParser.fromXml(new ByteArrayInputStream(decompressed), protectedStringCrypto);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open database file", e);
        }
    }

    public KeePassHeader getHeader() {
        return this.keepassHeader;
    }

    public static void write(KeePassFile keePassFile, String password, String keePassDatabaseFile) {
        if (keePassDatabaseFile == null || keePassDatabaseFile.isEmpty()) {
            throw new IllegalArgumentException("You must provide a non-empty path where the database should be written to.");
        }
        try {
            KeePassDatabase.write(keePassFile, password, new FileOutputStream(keePassDatabaseFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(KeePassFile keePassFile, String password, OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("You must provide a stream to write to.");
        }
        try {
            if (!KeePassDatabase.validateKeePassFile(keePassFile)) {
                throw new KeePassDatabaseUnwriteable("The provided keePassFile is not valid. A valid keePassFile must contain of meta and root group and the root group must at least contain one group.");
            }
            KeePassHeader header = new KeePassHeader();
            header.initialize();
            byte[] passwordBytes = password.getBytes("UTF-8");
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            Salsa20 protectedStringCrypto = Salsa20.createInstance(header.getProtectedStreamKey());
            byte[] keePassFilePayload = new KeePassDatabaseXmlParser().toXml(keePassFile, protectedStringCrypto).toByteArray();
            ByteArrayOutputStream streamToUnzip = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(streamToUnzip);
            gzipOutputStream.write(keePassFilePayload);
            gzipOutputStream.close();
            ByteArrayOutputStream streamToUnhashBlock = new ByteArrayOutputStream();
            HashedBlockOutputStream hashBlockOutputStream = new HashedBlockOutputStream(streamToUnhashBlock);
            hashBlockOutputStream.write(streamToUnzip.toByteArray());
            hashBlockOutputStream.close();
            ByteArrayOutputStream streamToEncrypt = new ByteArrayOutputStream();
            streamToEncrypt.write(header.getBytes());
            streamToEncrypt.write(header.getStreamStartBytes());
            streamToEncrypt.write(streamToUnhashBlock.toByteArray());
            byte[] encryptedDatabase = new Decrypter().encryptDatabase(hashedPassword, header, streamToEncrypt.toByteArray());
            stream.write(encryptedDatabase);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write database file", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean validateKeePassFile(KeePassFile keePassFile) {
        if (keePassFile == null || keePassFile.getMeta() == null) {
            return false;
        }
        return keePassFile.getRoot() != null && !keePassFile.getRoot().getGroups().isEmpty();
    }
}

