/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.GroupBuilder;
import de.slackspace.openkeepass.domain.KeePassFileElement;
import de.slackspace.openkeepass.domain.Times;
import de.slackspace.openkeepass.xml.BooleanXmlAdapter;
import de.slackspace.openkeepass.xml.UUIDXmlAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Group
implements KeePassFileElement {
    @XmlElement(name="UUID")
    @XmlJavaTypeAdapter(value=UUIDXmlAdapter.class)
    private UUID uuid;
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="IconID")
    private int iconId = 49;
    @XmlElement(name="Times")
    private Times times;
    @XmlElement(name="IsExpanded")
    @XmlJavaTypeAdapter(value=BooleanXmlAdapter.class)
    private Boolean isExpanded;
    @XmlElement(name="Entry")
    private List<Entry> entries = new ArrayList<Entry>();
    @XmlElement(name="Group")
    private List<Group> groups = new ArrayList<Group>();

    Group() {
        this.uuid = UUID.randomUUID();
    }

    public Group(GroupBuilder builder) {
        this.entries = builder.entries;
        this.groups = builder.groups;
        this.iconId = builder.iconId;
        this.isExpanded = builder.isExpanded;
        this.name = builder.name;
        this.times = builder.times;
        this.uuid = builder.uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Entry getEntryByTitle(String title) {
        for (Entry entry : this.entries) {
            if (!entry.getTitle().equalsIgnoreCase(title)) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public int getIconId() {
        return this.iconId;
    }

    public Times getTimes() {
        return this.times;
    }

    public boolean isExpanded() {
        if (this.isExpanded == null) {
            return false;
        }
        return this.isExpanded;
    }
}

