/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.GroupBuilder;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.Meta;
import de.slackspace.openkeepass.domain.MetaBuilder;
import de.slackspace.openkeepass.domain.zipper.GroupZipper;

public class KeePassFileBuilder {
    Meta meta;
    Group root;
    private GroupBuilder rootBuilder = new GroupBuilder();
    private GroupBuilder topGroupBuilder = new GroupBuilder();
    private KeePassFile keePassFile;

    public KeePassFileBuilder(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
        this.meta = keePassFile.getMeta();
        this.rootBuilder = new GroupBuilder(keePassFile.getRoot());
    }

    public KeePassFileBuilder(String databaseName) {
        this.meta = new MetaBuilder(databaseName).historyMaxItems(10L).build();
    }

    public KeePassFileBuilder(Meta meta) {
        this.meta = meta;
    }

    public KeePassFileBuilder withMeta(Meta meta) {
        this.meta = meta;
        return this;
    }

    public KeePassFileBuilder addTopGroups(Group ... groups) {
        for (Group group : groups) {
            this.rootBuilder.addGroup(group);
        }
        return this;
    }

    public KeePassFileBuilder addTopEntries(Entry ... entries) {
        for (Entry entry : entries) {
            this.topGroupBuilder.addEntry(entry);
        }
        return this;
    }

    public KeePassFile build() {
        this.setTopGroupNameIfNotExisting();
        this.root = this.rootBuilder.build();
        return new KeePassFile(this);
    }

    public GroupZipper getZipper() {
        return new GroupZipper(this.keePassFile);
    }

    private void setTopGroupNameIfNotExisting() {
        if (this.rootBuilder.groups.isEmpty()) {
            this.rootBuilder.addGroup(this.topGroupBuilder.name(this.meta.getDatabaseName()).build());
        }
    }
}

