/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.crypto.RandomGenerator;
import de.slackspace.openkeepass.domain.CompressionAlgorithm;
import de.slackspace.openkeepass.domain.CrsAlgorithm;
import de.slackspace.openkeepass.util.ByteUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class KeePassHeader {
    private static final int SIZE_OF_FIELD_LENGTH_BUFFER = 3;
    public static final int CIPHER = 2;
    public static final int COMPRESSION = 3;
    public static final int MASTER_SEED = 4;
    public static final int TRANSFORM_SEED = 5;
    public static final int TRANSFORM_ROUNDS = 6;
    public static final int ENCRYPTION_IV = 7;
    public static final int PROTECTED_STREAM_KEY = 8;
    public static final int STREAM_START_BYTES = 9;
    public static final int INNER_RANDOM_STREAM_ID = 10;
    private static final byte[] DATABASE_V2_FILE_SIGNATURE_1 = ByteUtils.hexStringToByteArray("03d9a29a");
    private static final byte[] DATABASE_V2_FILE_SIGNATURE_2 = ByteUtils.hexStringToByteArray("67fb4bb5");
    private static final byte[] DATABASE_V2_FILE_VERSION = ByteUtils.hexStringToByteArray("00000300");
    private static final byte[] DATABASE_V2_AES_CIPHER = ByteUtils.hexStringToByteArray("31C1F2E6BF714350BE5805216AFC5AFF");
    public static final int VERSION_SIGNATURE_LENGTH = 12;
    private static final int DATABASE_V2_FILE_SIGNATURE_1_INT = 3;
    private static final int DATABASE_V2_FILE_SIGNATURE_2_INT = 103;
    private static final int OLD_DATABASE_V1_FILE_SIGNATURE_1_INT = 3;
    private static final int OLD_DATABASE_V1_FILE_SIGNATURE_2_INT = 101;
    private byte[] cipher;
    private byte[] encryptionIV;
    private byte[] streamStartBytes;
    private byte[] masterSeed;
    private byte[] transformSeed;
    private byte[] protectedStreamKey;
    private CompressionAlgorithm compression;
    private long transformRounds;
    private CrsAlgorithm crsAlgorithm;

    public void setValue(int headerId, byte[] value) {
        switch (headerId) {
            case 2: {
                this.setCipher(value);
                break;
            }
            case 3: {
                this.setCompressionFlag(value);
                break;
            }
            case 4: {
                this.setMasterSeed(value);
                break;
            }
            case 5: {
                this.setTransformSeed(value);
                break;
            }
            case 6: {
                this.setTransformRounds(value);
                break;
            }
            case 7: {
                this.setEncryptionIV(value);
                break;
            }
            case 8: {
                this.setProtectedStreamKey(value);
                break;
            }
            case 9: {
                this.setStreamStartBytes(value);
                break;
            }
            case 10: {
                this.setInnerRandomStreamId(value);
            }
        }
    }

    public void checkVersionSupport(byte[] keepassFile) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(keepassFile));
        byte[] signature = new byte[12];
        bufferedInputStream.read(signature);
        ByteBuffer signatureBuffer = ByteBuffer.wrap(signature);
        signatureBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int signaturePart1 = ByteUtils.toUnsignedInt(signatureBuffer.getInt());
        int signaturePart2 = ByteUtils.toUnsignedInt(signatureBuffer.getInt());
        if (signaturePart1 == 3 && signaturePart2 == 103) {
            return;
        }
        if (signaturePart1 == 3 && signaturePart2 == 101) {
            throw new UnsupportedOperationException("The provided KeePass database file seems to be from KeePass 1.x which is not supported!");
        }
        throw new UnsupportedOperationException("The provided file seems to be no KeePass database file!");
    }

    public void read(byte[] keepassFile) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(keepassFile));
        bufferedInputStream.skip(12L);
        try {
            int fieldId;
            do {
                fieldId = bufferedInputStream.read();
                byte[] fieldLength = new byte[2];
                bufferedInputStream.read(fieldLength);
                ByteBuffer fieldLengthBuffer = ByteBuffer.wrap(fieldLength);
                fieldLengthBuffer.order(ByteOrder.LITTLE_ENDIAN);
                int fieldLengthInt = ByteUtils.toUnsignedInt(fieldLengthBuffer.getShort());
                if (fieldLengthInt <= 0) continue;
                byte[] data = new byte[fieldLengthInt];
                bufferedInputStream.read(data);
                this.setValue(fieldId, data);
            } while (fieldId != 0);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read header input", e);
        }
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(DATABASE_V2_FILE_SIGNATURE_1);
            stream.write(DATABASE_V2_FILE_SIGNATURE_2);
            stream.write(DATABASE_V2_FILE_VERSION);
            for (int i = 2; i < 11; ++i) {
                byte[] headerValue = this.getValue(i);
                stream.write(i);
                byte[] length = new byte[]{(byte)headerValue.length, 0};
                stream.write(length);
                stream.write(headerValue);
            }
            stream.write(this.getEndOfHeader());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write header value to stream", e);
        }
    }

    private byte[] getEndOfHeader() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(0);
            stream.write(4);
            stream.write(0);
            stream.write("\r\n\r\n".getBytes());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write end of header to stream", e);
        }
    }

    public byte[] getValue(int headerId) {
        switch (headerId) {
            case 2: {
                return this.getCipher();
            }
            case 3: {
                return this.getCompressionFlag();
            }
            case 4: {
                return this.getMasterSeed();
            }
            case 5: {
                return this.getTransformSeed();
            }
            case 6: {
                return this.getTransformRoundsByte();
            }
            case 7: {
                return this.getEncryptionIV();
            }
            case 8: {
                return this.getProtectedStreamKey();
            }
            case 9: {
                return this.getStreamStartBytes();
            }
            case 10: {
                return this.getInnerRandomStreamId();
            }
        }
        return new byte[0];
    }

    private void setInnerRandomStreamId(byte[] value) {
        ByteBuffer buffer = this.wrapInBuffer(value);
        int intValue = buffer.getInt();
        this.crsAlgorithm = CrsAlgorithm.parseValue(intValue);
    }

    private byte[] getInnerRandomStreamId() {
        int intValue = CrsAlgorithm.getIntValue(this.crsAlgorithm);
        return this.wrapInBuffer(intValue);
    }

    private void setStreamStartBytes(byte[] value) {
        this.streamStartBytes = value;
    }

    private void setProtectedStreamKey(byte[] value) {
        this.protectedStreamKey = value;
    }

    private void setEncryptionIV(byte[] value) {
        this.encryptionIV = value;
    }

    private void setTransformRounds(byte[] value) {
        ByteBuffer buffer = this.wrapInBuffer(value);
        this.transformRounds = buffer.getLong();
    }

    private void setTransformSeed(byte[] value) {
        this.transformSeed = value;
    }

    private void setMasterSeed(byte[] value) {
        this.masterSeed = value;
    }

    private void setCompressionFlag(byte[] value) {
        ByteBuffer buffer = this.wrapInBuffer(value);
        int intValue = buffer.getInt();
        this.compression = CompressionAlgorithm.parseValue(intValue);
    }

    public void setCompression(CompressionAlgorithm algorithm) {
        this.compression = algorithm;
    }

    private byte[] getCompressionFlag() {
        int intValue = CompressionAlgorithm.getIntValue(this.compression);
        return this.wrapInBuffer(intValue);
    }

    private void setCipher(byte[] value) {
        if (value == null || value.length != 16) {
            throw new IllegalArgumentException("The encryption cipher must contain 16 bytes!");
        }
        this.cipher = value;
    }

    public byte[] getCipher() {
        return this.cipher;
    }

    public CompressionAlgorithm getCompression() {
        return this.compression;
    }

    public long getTransformRounds() {
        return this.transformRounds;
    }

    public void setTransformRounds(long rounds) {
        this.transformRounds = rounds;
    }

    private byte[] getTransformRoundsByte() {
        return this.wrapInBuffer(this.transformRounds);
    }

    public byte[] getEncryptionIV() {
        return this.encryptionIV;
    }

    public byte[] getStreamStartBytes() {
        return this.streamStartBytes;
    }

    public CrsAlgorithm getCrsAlgorithm() {
        return this.crsAlgorithm;
    }

    public void setCrsAlgorithm(CrsAlgorithm algorithm) {
        this.crsAlgorithm = algorithm;
    }

    public byte[] getMasterSeed() {
        return this.masterSeed;
    }

    public byte[] getTransformSeed() {
        return this.transformSeed;
    }

    public int getHeaderSize() {
        int size = 0;
        for (int i = 2; i < 11; ++i) {
            byte[] value = this.getValue(i);
            if (value == null) continue;
            size += value.length + 3;
        }
        return size += this.getEndOfHeader().length;
    }

    public byte[] getProtectedStreamKey() {
        return this.protectedStreamKey;
    }

    private ByteBuffer wrapInBuffer(byte[] value) {
        ByteBuffer buffer = ByteBuffer.wrap(value);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    private byte[] wrapInBuffer(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(value);
        return buffer.array();
    }

    private byte[] wrapInBuffer(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(value);
        return buffer.array();
    }

    public void initialize() {
        RandomGenerator random = new RandomGenerator();
        this.setCompression(CompressionAlgorithm.Gzip);
        this.setCrsAlgorithm(CrsAlgorithm.Salsa20);
        this.setTransformRounds(8000L);
        this.setMasterSeed(random.getRandomBytes(32));
        this.setTransformSeed(random.getRandomBytes(32));
        this.setEncryptionIV(random.getRandomBytes(16));
        this.setProtectedStreamKey(random.getRandomBytes(32));
        this.setStreamStartBytes(random.getRandomBytes(32));
        this.setCipher(DATABASE_V2_AES_CIPHER);
    }
}

