/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain.zipper;

import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.KeePassFileBuilder;
import de.slackspace.openkeepass.domain.Meta;

public class GroupZipper {
    private Meta meta;
    private int index = 0;
    private Group node;
    private GroupZipper parent;

    public GroupZipper(KeePassFile keePassFile) {
        this.meta = keePassFile.getMeta();
        this.node = keePassFile.getRoot().getGroups().get(0);
    }

    private GroupZipper(GroupZipper parent, Group group) {
        this.parent = parent;
        this.node = group;
    }

    public GroupZipper down() {
        if (this.node.getGroups() == null || this.node.getGroups().isEmpty()) {
            throw new RuntimeException("Could not move down because this group does not have any children");
        }
        this.index = 0;
        this.parent = new GroupZipper(this.parent, this.node);
        this.node = this.node.getGroups().get(0);
        return this;
    }

    public GroupZipper up() {
        if (this.parent == null) {
            throw new RuntimeException("Could not move up because this group does not have a parent");
        }
        return this.parent;
    }

    public GroupZipper right() {
        if (this.index + 1 >= this.parent.getNode().getGroups().size()) {
            throw new RuntimeException("Could not move right because the last node at this level has already been reached");
        }
        ++this.index;
        this.node = this.parent.getNode().getGroups().get(this.index);
        return this;
    }

    public GroupZipper left() {
        if (this.index - 1 < 0) {
            throw new RuntimeException("Could not move left because the first node at this level has already been reached");
        }
        --this.index;
        this.node = this.parent.getNode().getGroups().get(this.index);
        return this;
    }

    public Group getNode() {
        return this.node;
    }

    public GroupZipper replace(Group group) {
        this.parent.getNode().getGroups().set(this.index, group);
        return this;
    }

    public KeePassFile close() {
        Group rootNode = this.getRoot();
        return new KeePassFileBuilder(this.meta).addTopGroups(rootNode).build();
    }

    public Group getRoot() {
        if (this.parent == null) {
            return this.node;
        }
        return this.parent.getRoot();
    }

    public GroupZipper replaceMeta(Meta meta) {
        this.meta = meta;
        return this;
    }
}

