/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.stream;

import de.slackspace.openkeepass.util.ByteUtils;
import de.slackspace.openkeepass.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class HashedBlockInputStream
extends InputStream {
    private static final int HASH_SIZE = 32;
    private InputStream baseStream;
    private int bufferPos = 0;
    private byte[] buffer = new byte[0];
    private long bufferIndex = 0L;
    private boolean atEnd = false;

    public HashedBlockInputStream(InputStream is) {
        this.baseStream = is;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int copyLen;
        if (this.atEnd) {
            return -1;
        }
        for (int remaining = length; remaining > 0; remaining -= copyLen) {
            if (this.bufferPos == this.buffer.length && !this.readHashedBlock()) {
                return length - remaining;
            }
            copyLen = Math.min(this.buffer.length - this.bufferPos, remaining);
            System.arraycopy(this.buffer, this.bufferPos, b, offset, copyLen);
            offset += copyLen;
            this.bufferPos += copyLen;
        }
        return length;
    }

    private boolean readHashedBlock() throws IOException {
        if (this.atEnd) {
            return false;
        }
        this.bufferPos = 0;
        long index = ByteUtils.readUnsignedInt(this.baseStream);
        if (index != this.bufferIndex) {
            throw new IOException("Invalid data format");
        }
        ++this.bufferIndex;
        byte[] storedHash = new byte[32];
        StreamUtils.read(this.baseStream, storedHash);
        if (storedHash == null || storedHash.length != 32) {
            throw new IOException("Invalid data format");
        }
        int bufferSize = ByteUtils.readInt(this.baseStream);
        if (bufferSize < 0) {
            throw new IOException("Invalid data format");
        }
        if (bufferSize == 0) {
            for (int hash = 0; hash < 32; ++hash) {
                if (storedHash[hash] == 0) continue;
                throw new IOException("Invalid data format");
            }
            this.atEnd = true;
            this.buffer = new byte[0];
            return false;
        }
        this.buffer = new byte[bufferSize];
        StreamUtils.read(this.baseStream, this.buffer);
        if (this.buffer == null || this.buffer.length != bufferSize) {
            throw new IOException("Invalid data format");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("SHA-256 not implemented here.");
        }
        byte[] computedHash = md.digest(this.buffer);
        if (computedHash == null || computedHash.length != 32) {
            throw new IOException("Hash wrong size");
        }
        if (!Arrays.equals(storedHash, computedHash)) {
            throw new IOException("Hashes didn't match.");
        }
        return true;
    }

    @Override
    public long skip(long n) throws IOException {
        return 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.atEnd) {
            return -1;
        }
        if (this.bufferPos == this.buffer.length && !this.readHashedBlock()) {
            return -1;
        }
        byte output = this.buffer[this.bufferPos];
        ++this.bufferPos;
        return output;
    }

    @Override
    public void close() throws IOException {
        this.baseStream.close();
    }
}

