/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashedBlockOutputStream
extends OutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private OutputStream baseStream;
    private int bufferPos = 0;
    private byte[] buffer = new byte[0x100000];
    private long bufferIndex = 0L;

    public HashedBlockOutputStream(OutputStream os) {
        this.baseStream = os;
    }

    @Override
    public void write(int oneByte) throws IOException {
        byte[] buf = new byte[]{(byte)oneByte};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.bufferPos != 0) {
            this.writeHashedBlock();
        }
        this.writeHashedBlock();
        this.flush();
        this.baseStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.baseStream.flush();
    }

    @Override
    public void write(byte[] b, int offset, int count) throws IOException {
        while (count > 0) {
            if (this.bufferPos == this.buffer.length) {
                this.writeHashedBlock();
            }
            int copyLen = Math.min(this.buffer.length - this.bufferPos, count);
            System.arraycopy(b, offset, this.buffer, this.bufferPos, copyLen);
            offset += copyLen;
            this.bufferPos += copyLen;
            count -= copyLen;
        }
    }

    private void writeHashedBlock() throws IOException {
        this.writeUInt(this.bufferIndex);
        ++this.bufferIndex;
        if (this.bufferPos > 0) {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("SHA-256 not implemented here.");
            }
            md.update(this.buffer, 0, this.bufferPos);
            byte[] hash = md.digest();
            this.baseStream.write(hash);
        } else {
            this.writeLong(0L);
            this.writeLong(0L);
            this.writeLong(0L);
            this.writeLong(0L);
        }
        this.writeInt(this.bufferPos);
        if (this.bufferPos > 0) {
            this.baseStream.write(this.buffer, 0, this.bufferPos);
        }
        this.bufferPos = 0;
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void writeUInt(long uint) throws IOException {
        this.baseStream.write(this.writeIntBuf((int)uint));
    }

    public void writeInt(int val) throws IOException {
        byte[] buf = new byte[4];
        this.writeInt(val, buf, 0);
        this.baseStream.write(buf);
    }

    public byte[] writeIntBuf(int val) {
        byte[] buf = new byte[4];
        this.writeInt(val, buf, 0);
        return buf;
    }

    public void writeInt(int val, byte[] buf, int offset) {
        buf[offset + 0] = (byte)(val & 0xFF);
        buf[offset + 1] = (byte)(val >>> 8 & 0xFF);
        buf[offset + 2] = (byte)(val >>> 16 & 0xFF);
        buf[offset + 3] = (byte)(val >>> 24 & 0xFF);
    }

    public void writeLong(long val) throws IOException {
        byte[] buf = new byte[8];
        this.writeLong(val, buf, 0);
        this.baseStream.write(buf);
    }

    public void writeLong(long val, byte[] buf, int offset) {
        buf[offset + 0] = (byte)(val & 0xFFL);
        buf[offset + 1] = (byte)(val >>> 8 & 0xFFL);
        buf[offset + 2] = (byte)(val >>> 16 & 0xFFL);
        buf[offset + 3] = (byte)(val >>> 24 & 0xFFL);
        buf[offset + 4] = (byte)(val >>> 32 & 0xFFL);
        buf[offset + 5] = (byte)(val >>> 40 & 0xFFL);
        buf[offset + 6] = (byte)(val >>> 48 & 0xFFL);
        buf[offset + 7] = (byte)(val >>> 56 & 0xFFL);
    }
}

