/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.xml;

import de.slackspace.openkeepass.crypto.ProtectedStringCrypto;
import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.History;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.Property;
import de.slackspace.openkeepass.domain.PropertyValue;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXB;

public class KeePassDatabaseXmlParser {
    public KeePassFile fromXml(InputStream inputStream, ProtectedStringCrypto protectedStringCrypto) {
        KeePassFile keePassFile = (KeePassFile)JAXB.unmarshal((InputStream)inputStream, KeePassFile.class);
        this.processAllProtectedValues(false, protectedStringCrypto, keePassFile);
        return keePassFile;
    }

    public ByteArrayOutputStream toXml(KeePassFile keePassFile, ProtectedStringCrypto protectedStringCrypto) {
        this.processAllProtectedValues(true, protectedStringCrypto, keePassFile);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JAXB.marshal((Object)keePassFile, (OutputStream)outputStream);
        return outputStream;
    }

    private void processAllProtectedValues(boolean encrypt, ProtectedStringCrypto protectedStringCrypto, KeePassFile keePassFile) {
        List<Entry> entries = keePassFile.getEntries();
        for (Entry entry : entries) {
            this.processProtectedValues(encrypt, entry, protectedStringCrypto);
            History history = entry.getHistory();
            if (history == null) continue;
            for (Entry historicEntry : history.getHistoricEntries()) {
                this.processProtectedValues(encrypt, historicEntry, protectedStringCrypto);
            }
        }
    }

    private void processProtectedValues(boolean encrypt, Entry entry, ProtectedStringCrypto protectedStringCrypto) {
        ArrayList<Property> removeList = new ArrayList<Property>();
        ArrayList<Property> addList = new ArrayList<Property>();
        List<Property> properties = entry.getProperties();
        for (Property property : properties) {
            PropertyValue propertyValue = property.getPropertyValue();
            if (propertyValue.getValue() == null || propertyValue.getValue().isEmpty() || !propertyValue.isProtected()) continue;
            String processedValue = null;
            processedValue = encrypt ? protectedStringCrypto.encrypt(propertyValue.getValue()) : protectedStringCrypto.decrypt(propertyValue.getValue());
            removeList.add(property);
            addList.add(new Property(property.getKey(), processedValue, property.isProtected()));
        }
        properties.removeAll(removeList);
        properties.addAll(addList);
    }
}

