/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass;

import de.slackspace.openkeepass.crypto.Decrypter;
import de.slackspace.openkeepass.crypto.Salsa20;
import de.slackspace.openkeepass.crypto.Sha256;
import de.slackspace.openkeepass.domain.CompressionAlgorithm;
import de.slackspace.openkeepass.domain.CrsAlgorithm;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.KeePassHeader;
import de.slackspace.openkeepass.domain.KeyFile;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnreadable;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnwriteable;
import de.slackspace.openkeepass.processor.DecryptionStrategy;
import de.slackspace.openkeepass.processor.EncryptionStrategy;
import de.slackspace.openkeepass.processor.IconEnricher;
import de.slackspace.openkeepass.processor.ProtectedValueProcessor;
import de.slackspace.openkeepass.stream.HashedBlockInputStream;
import de.slackspace.openkeepass.stream.HashedBlockOutputStream;
import de.slackspace.openkeepass.util.ByteUtils;
import de.slackspace.openkeepass.util.SafeInputStream;
import de.slackspace.openkeepass.util.StreamUtils;
import de.slackspace.openkeepass.xml.KeePassDatabaseXmlParser;
import de.slackspace.openkeepass.xml.KeyFileXmlParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.util.encoders.Base64;

public class KeePassDatabase {
    private static final String UTF_8 = "UTF-8";
    private static final String MSG_UTF8_NOT_SUPPORTED = "The encoding UTF-8 is not supported";
    private static final String MSG_EMPTY_MASTER_KEY = "The password for the database must not be null. Please provide a valid password.";
    private KeePassHeader keepassHeader = new KeePassHeader();
    private byte[] keepassFile;
    protected Decrypter decrypter = new Decrypter();
    protected KeePassDatabaseXmlParser keePassDatabaseXmlParser = new KeePassDatabaseXmlParser();
    protected KeyFileXmlParser keyFileXmlParser = new KeyFileXmlParser();

    private KeePassDatabase(InputStream inputStream) {
        try {
            this.keepassFile = StreamUtils.toByteArray(inputStream);
            this.keepassHeader.checkVersionSupport(this.keepassFile);
            this.keepassHeader.read(this.keepassFile);
        }
        catch (IOException e) {
            throw new KeePassDatabaseUnreadable("Could not open database file", e);
        }
    }

    public static KeePassDatabase getInstance(String keePassDatabaseFile) {
        return KeePassDatabase.getInstance(new File(keePassDatabaseFile));
    }

    public static KeePassDatabase getInstance(File keePassDatabaseFile) {
        if (keePassDatabaseFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass database file.");
        }
        FileInputStream keePassDatabaseStream = null;
        try {
            keePassDatabaseStream = new FileInputStream(keePassDatabaseFile);
            KeePassDatabase keePassDatabase = KeePassDatabase.getInstance(keePassDatabaseStream);
            return keePassDatabase;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass database file could not be found. You must provide a valid KeePass database file.", e);
        }
        finally {
            if (keePassDatabaseStream != null) {
                try {
                    ((InputStream)keePassDatabaseStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static KeePassDatabase getInstance(InputStream keePassDatabaseStream) {
        if (keePassDatabaseStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass database stream.");
        }
        return new KeePassDatabase(keePassDatabaseStream);
    }

    public KeePassFile openDatabase(String password) {
        if (password == null) {
            throw new IllegalArgumentException(MSG_EMPTY_MASTER_KEY);
        }
        try {
            byte[] passwordBytes = password.getBytes(UTF_8);
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            return this.decryptAndParseDatabase(hashedPassword);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(MSG_UTF8_NOT_SUPPORTED, e);
        }
    }

    public KeePassFile openDatabase(String password, File keyFile) {
        if (password == null) {
            throw new IllegalArgumentException(MSG_EMPTY_MASTER_KEY);
        }
        if (keyFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass keyfile.");
        }
        try {
            return this.openDatabase(password, new FileInputStream(keyFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass keyfile could not be found. You must provide a valid KeePass keyfile.", e);
        }
    }

    public KeePassFile openDatabase(String password, InputStream keyFileStream) {
        if (password == null) {
            throw new IllegalArgumentException(MSG_EMPTY_MASTER_KEY);
        }
        if (keyFileStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass keyfile stream.");
        }
        try {
            byte[] passwordBytes = password.getBytes(UTF_8);
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            KeyFile keyFile = this.keyFileXmlParser.fromXml(keyFileStream);
            byte[] protectedBuffer = Base64.decode((byte[])keyFile.getKey().getData().getBytes(UTF_8));
            if (protectedBuffer.length != 32) {
                protectedBuffer = Sha256.hash(protectedBuffer);
            }
            return this.decryptAndParseDatabase(ByteUtils.concat(hashedPassword, protectedBuffer));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(MSG_UTF8_NOT_SUPPORTED, e);
        }
    }

    public KeePassFile openDatabase(File keyFile) {
        if (keyFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass keyfile.");
        }
        try {
            return this.openDatabase(new FileInputStream(keyFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass keyfile could not be found. You must provide a valid KeePass keyfile.", e);
        }
    }

    public KeePassFile openDatabase(InputStream keyFileStream) {
        if (keyFileStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass keyfile stream.");
        }
        try {
            KeyFile keyFile = this.keyFileXmlParser.fromXml(keyFileStream);
            byte[] protectedBuffer = Base64.decode((byte[])keyFile.getKey().getData().getBytes(UTF_8));
            return this.decryptAndParseDatabase(protectedBuffer);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(MSG_UTF8_NOT_SUPPORTED, e);
        }
    }

    private KeePassFile decryptAndParseDatabase(byte[] key) {
        try {
            byte[] hashedBlockBytes;
            byte[] aesDecryptedDbFile = this.decrypter.decryptDatabase(key, this.keepassHeader, this.keepassFile);
            byte[] startBytes = new byte[32];
            SafeInputStream decryptedStream = new SafeInputStream(new ByteArrayInputStream(aesDecryptedDbFile));
            decryptedStream.skipSafe(12L + (long)this.keepassHeader.getHeaderSize());
            decryptedStream.readSafe(startBytes);
            if (!Arrays.equals(this.keepassHeader.getStreamStartBytes(), startBytes)) {
                throw new KeePassDatabaseUnreadable("The keepass database file seems to be corrupt or cannot be decrypted.");
            }
            HashedBlockInputStream hashedBlockInputStream = new HashedBlockInputStream(decryptedStream);
            byte[] decompressed = hashedBlockBytes = StreamUtils.toByteArray(hashedBlockInputStream);
            if (this.keepassHeader.getCompression().equals((Object)CompressionAlgorithm.Gzip)) {
                GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(hashedBlockBytes));
                decompressed = StreamUtils.toByteArray(gzipInputStream);
            }
            if (!this.keepassHeader.getCrsAlgorithm().equals((Object)CrsAlgorithm.Salsa20)) {
                throw new UnsupportedOperationException("Only Salsa20 is supported as CrsAlgorithm at the moment!");
            }
            Salsa20 protectedStringCrypto = Salsa20.createInstance(this.keepassHeader.getProtectedStreamKey());
            KeePassFile unprocessedKeepassFile = this.keePassDatabaseXmlParser.fromXml(new ByteArrayInputStream(decompressed));
            new ProtectedValueProcessor().processProtectedValues(new DecryptionStrategy(protectedStringCrypto), unprocessedKeepassFile);
            return new IconEnricher().enrichNodesWithIconData(unprocessedKeepassFile);
        }
        catch (IOException e) {
            throw new KeePassDatabaseUnreadable("Could not open database file", e);
        }
    }

    public KeePassHeader getHeader() {
        return this.keepassHeader;
    }

    public static void write(KeePassFile keePassFile, String password, String keePassDatabaseFile) {
        if (keePassDatabaseFile == null || keePassDatabaseFile.isEmpty()) {
            throw new IllegalArgumentException("You must provide a non-empty path where the database should be written to.");
        }
        try {
            KeePassDatabase.write(keePassFile, password, new FileOutputStream(keePassDatabaseFile));
        }
        catch (FileNotFoundException e) {
            throw new KeePassDatabaseUnreadable("Could not find database file", e);
        }
    }

    public static void write(KeePassFile keePassFile, String password, OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("You must provide a stream to write to.");
        }
        try {
            if (!KeePassDatabase.validateKeePassFile(keePassFile)) {
                throw new KeePassDatabaseUnwriteable("The provided keePassFile is not valid. A valid keePassFile must contain of meta and root group and the root group must at least contain one group.");
            }
            KeePassHeader header = new KeePassHeader();
            header.initialize();
            byte[] passwordBytes = password.getBytes(UTF_8);
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            Salsa20 protectedStringCrypto = Salsa20.createInstance(header.getProtectedStreamKey());
            new ProtectedValueProcessor().processProtectedValues(new EncryptionStrategy(protectedStringCrypto), keePassFile);
            byte[] keePassFilePayload = new KeePassDatabaseXmlParser().toXml(keePassFile).toByteArray();
            ByteArrayOutputStream streamToUnzip = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(streamToUnzip);
            gzipOutputStream.write(keePassFilePayload);
            gzipOutputStream.close();
            ByteArrayOutputStream streamToUnhashBlock = new ByteArrayOutputStream();
            HashedBlockOutputStream hashBlockOutputStream = new HashedBlockOutputStream(streamToUnhashBlock);
            hashBlockOutputStream.write(streamToUnzip.toByteArray());
            hashBlockOutputStream.close();
            ByteArrayOutputStream streamToEncrypt = new ByteArrayOutputStream();
            streamToEncrypt.write(header.getBytes());
            streamToEncrypt.write(header.getStreamStartBytes());
            streamToEncrypt.write(streamToUnhashBlock.toByteArray());
            byte[] encryptedDatabase = new Decrypter().encryptDatabase(hashedPassword, header, streamToEncrypt.toByteArray());
            stream.write(encryptedDatabase);
        }
        catch (IOException e) {
            throw new KeePassDatabaseUnwriteable("Could not write database file", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean validateKeePassFile(KeePassFile keePassFile) {
        if (keePassFile == null || keePassFile.getMeta() == null) {
            return false;
        }
        return keePassFile.getRoot() != null && !keePassFile.getRoot().getGroups().isEmpty();
    }
}

