/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.EntryBuilder;
import de.slackspace.openkeepass.domain.History;
import de.slackspace.openkeepass.domain.KeePassFileElement;
import de.slackspace.openkeepass.domain.Property;
import de.slackspace.openkeepass.xml.UUIDXmlAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Entry
implements KeePassFileElement {
    private static final String USER_NAME = "UserName";
    private static final String NOTES = "Notes";
    private static final String URL = "URL";
    private static final String PASSWORD = "Password";
    private static final String TITLE = "Title";
    private static final List<String> PROPERTY_KEYS = new ArrayList<String>();
    @XmlElement(name="UUID")
    @XmlJavaTypeAdapter(value=UUIDXmlAdapter.class)
    private UUID uuid;
    @XmlElement(name="IconID")
    private int iconId = 0;
    private transient byte[] iconData;
    @XmlElement(name="CustomIconUUID")
    @XmlJavaTypeAdapter(value=UUIDXmlAdapter.class)
    private UUID customIconUUID;
    @XmlElement(name="String")
    private List<Property> properties = new ArrayList<Property>();
    @XmlElement(name="History")
    private History history;

    Entry() {
        this.uuid = UUID.randomUUID();
    }

    public Entry(EntryBuilder builder) {
        this.history = builder.history;
        this.uuid = builder.uuid;
        this.iconData = builder.iconData;
        this.iconId = builder.iconId;
        this.customIconUUID = builder.customIconUUID;
        this.setValue(false, NOTES, builder.notes);
        this.setValue(true, PASSWORD, builder.password);
        this.setValue(false, TITLE, builder.title);
        this.setValue(false, USER_NAME, builder.username);
        this.setValue(false, URL, builder.url);
        this.properties.addAll(builder.customPropertyList);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getIconId() {
        return this.iconId;
    }

    public UUID getCustomIconUuid() {
        return this.customIconUUID;
    }

    public byte[] getIconData() {
        return this.iconData;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Property> getCustomProperties() {
        ArrayList<Property> customProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (PROPERTY_KEYS.contains(property.getKey())) continue;
            customProperties.add(property);
        }
        return customProperties;
    }

    public String getTitle() {
        return this.getValueFromProperty(TITLE);
    }

    public String getPassword() {
        return this.getValueFromProperty(PASSWORD);
    }

    public String getUrl() {
        return this.getValueFromProperty(URL);
    }

    public String getNotes() {
        return this.getValueFromProperty(NOTES);
    }

    public String getUsername() {
        return this.getValueFromProperty(USER_NAME);
    }

    public boolean isTitleProtected() {
        return this.getPropertyByName(TITLE).isProtected();
    }

    public boolean isPasswordProtected() {
        return this.getPropertyByName(PASSWORD).isProtected();
    }

    private void setValue(boolean isProtected, String propertyName, String propertyValue) {
        Property property = this.getPropertyByName(propertyName);
        if (property == null) {
            property = new Property(propertyName, propertyValue, isProtected);
            this.properties.add(property);
        } else {
            this.properties.remove(property);
            this.properties.add(new Property(propertyName, propertyValue, isProtected));
        }
    }

    private String getValueFromProperty(String name) {
        Property property = this.getPropertyByName(name);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public Property getPropertyByName(String name) {
        for (Property property : this.properties) {
            if (!property.getKey().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    public History getHistory() {
        return this.history;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.history == null ? 0 : this.history.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)obj;
        if (this.history == null ? other.history != null : !this.history.equals(other.history)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String toString() {
        return "Entry [uuid=" + this.uuid + ", getTitle()=" + this.getTitle() + ", getPassword()=" + this.getPassword() + ", getUsername()=" + this.getUsername() + "]";
    }

    static {
        PROPERTY_KEYS.add(USER_NAME);
        PROPERTY_KEYS.add(NOTES);
        PROPERTY_KEYS.add(URL);
        PROPERTY_KEYS.add(PASSWORD);
        PROPERTY_KEYS.add(TITLE);
    }
}

