/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.GroupBuilder;
import de.slackspace.openkeepass.domain.KeePassFileElement;
import de.slackspace.openkeepass.domain.Times;
import de.slackspace.openkeepass.xml.BooleanXmlAdapter;
import de.slackspace.openkeepass.xml.UUIDXmlAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Group
implements KeePassFileElement {
    @XmlElement(name="UUID")
    @XmlJavaTypeAdapter(value=UUIDXmlAdapter.class)
    private UUID uuid;
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="IconID")
    private int iconId = 49;
    private transient byte[] iconData;
    @XmlElement(name="CustomIconUUID")
    @XmlJavaTypeAdapter(value=UUIDXmlAdapter.class)
    private UUID customIconUUID;
    @XmlElement(name="Times")
    private Times times;
    @XmlElement(name="IsExpanded")
    @XmlJavaTypeAdapter(value=BooleanXmlAdapter.class)
    private Boolean isExpanded;
    @XmlElement(name="Entry")
    private List<Entry> entries = new ArrayList<Entry>();
    @XmlElement(name="Group")
    private List<Group> groups = new ArrayList<Group>();

    Group() {
        this.uuid = UUID.randomUUID();
    }

    public Group(GroupBuilder builder) {
        this.entries = builder.entries;
        this.groups = builder.groups;
        this.iconId = builder.iconId;
        this.isExpanded = builder.isExpanded;
        this.name = builder.name;
        this.times = builder.times;
        this.uuid = builder.uuid;
        this.iconData = builder.iconData;
        this.customIconUUID = builder.customIconUuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Entry getEntryByTitle(String title) {
        for (Entry entry : this.entries) {
            if (!entry.getTitle().equalsIgnoreCase(title)) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public int getIconId() {
        return this.iconId;
    }

    public UUID getCustomIconUuid() {
        return this.customIconUUID;
    }

    public byte[] getIconData() {
        return this.iconData;
    }

    public Times getTimes() {
        return this.times;
    }

    public boolean isExpanded() {
        if (this.isExpanded == null) {
            return false;
        }
        return this.isExpanded;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customIconUUID == null ? 0 : this.customIconUUID.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        result = 31 * result + this.iconId;
        result = 31 * result + (this.isExpanded == null ? 0 : this.isExpanded.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.times == null ? 0 : this.times.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (this.customIconUUID == null ? other.customIconUUID != null : !this.customIconUUID.equals(other.customIconUUID)) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.iconId != other.iconId) {
            return false;
        }
        if (this.isExpanded == null ? other.isExpanded != null : !this.isExpanded.equals(other.isExpanded)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.times == null ? other.times != null : !this.times.equals(other.times)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

