/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.processor;

import de.slackspace.openkeepass.domain.CustomIcon;
import de.slackspace.openkeepass.domain.CustomIcons;
import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.EntryBuilder;
import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.GroupBuilder;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.zipper.GroupZipper;
import de.slackspace.openkeepass.exception.IconUnreadableException;
import de.slackspace.openkeepass.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class IconEnricher {
    private static final String PNG = ".png";
    private static final String ICONS = "/icons/";

    public KeePassFile enrichNodesWithIconData(KeePassFile keePassFile) {
        CustomIcons iconLibrary = keePassFile.getMeta().getCustomIcons();
        GroupZipper zipper = new GroupZipper(keePassFile);
        Iterator<Group> iter = zipper.iterator();
        while (iter.hasNext()) {
            Group group = iter.next();
            byte[] iconData = this.getIconData(group.getCustomIconUuid(), group.getIconId(), iconLibrary);
            Group groupWithIcon = new GroupBuilder(group).iconData(iconData).build();
            zipper.replace(groupWithIcon);
            this.enrichEntriesWithIcons(iconLibrary, group);
        }
        return zipper.close();
    }

    private void enrichEntriesWithIcons(CustomIcons iconLibrary, Group group) {
        ArrayList<Entry> removeList = new ArrayList<Entry>();
        ArrayList<Entry> addList = new ArrayList<Entry>();
        List<Entry> entries = group.getEntries();
        for (Entry entry : entries) {
            byte[] entryIconData = this.getIconData(entry.getCustomIconUuid(), entry.getIconId(), iconLibrary);
            Entry entryWithIcon = new EntryBuilder(entry).iconData(entryIconData).build();
            removeList.add(entry);
            addList.add(entryWithIcon);
        }
        group.getEntries().removeAll(removeList);
        group.getEntries().addAll(addList);
    }

    private byte[] getIconData(UUID customIconUuid, int stockIconId, CustomIcons iconLibrary) {
        byte[] iconData;
        if (customIconUuid != null) {
            CustomIcon icon = iconLibrary.getIconByUuid(customIconUuid);
            iconData = icon.getData();
        } else {
            iconData = this.getStockIconData(stockIconId);
        }
        return iconData;
    }

    private byte[] getStockIconData(int iconId) {
        if (iconId < 0) {
            return null;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(ICONS + iconId + PNG);
        if (inputStream == null) {
            return null;
        }
        try {
            return StreamUtils.toByteArray(inputStream);
        }
        catch (IOException e) {
            throw new IconUnreadableException("Could not read icon data from resource '/icons/" + iconId + PNG + "'", e);
        }
    }
}

