/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.api;

import de.slackspace.openkeepass.crypto.CryptoInformation;
import de.slackspace.openkeepass.crypto.Decrypter;
import de.slackspace.openkeepass.crypto.ProtectedStringCrypto;
import de.slackspace.openkeepass.crypto.Salsa20;
import de.slackspace.openkeepass.domain.CompressionAlgorithm;
import de.slackspace.openkeepass.domain.CrsAlgorithm;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.KeePassHeader;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnreadableException;
import de.slackspace.openkeepass.parser.KeePassDatabaseXmlParser;
import de.slackspace.openkeepass.parser.SimpleXmlParser;
import de.slackspace.openkeepass.processor.DecryptionStrategy;
import de.slackspace.openkeepass.processor.IconEnricher;
import de.slackspace.openkeepass.processor.ProtectedValueProcessor;
import de.slackspace.openkeepass.stream.HashedBlockInputStream;
import de.slackspace.openkeepass.util.SafeInputStream;
import de.slackspace.openkeepass.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public class KeePassDatabaseReader {
    protected Decrypter decrypter = new Decrypter();
    protected KeePassDatabaseXmlParser keePassDatabaseXmlParser = new KeePassDatabaseXmlParser(new SimpleXmlParser());
    private KeePassHeader keepassHeader;

    public KeePassDatabaseReader(KeePassHeader keepassHeader) {
        this.keepassHeader = keepassHeader;
    }

    public KeePassFile decryptAndParseDatabase(byte[] key, byte[] keepassFile) {
        try {
            byte[] aesDecryptedDbFile = this.decryptStream(key, keepassFile);
            SafeInputStream decryptedStream = this.skipMetadata(aesDecryptedDbFile);
            byte[] hashedBlockBytes = this.unHashBlockStream(decryptedStream);
            byte[] decompressed = this.decompressStream(hashedBlockBytes);
            ProtectedStringCrypto protectedStringCrypto = this.getProtectedStringCrypto();
            return this.parseDatabase(decompressed, protectedStringCrypto);
        }
        catch (IOException e) {
            throw new KeePassDatabaseUnreadableException("Could not open database file", e);
        }
    }

    private byte[] unHashBlockStream(SafeInputStream decryptedStream) throws IOException {
        HashedBlockInputStream hashedBlockInputStream = new HashedBlockInputStream(decryptedStream);
        return StreamUtils.toByteArray(hashedBlockInputStream);
    }

    private KeePassFile parseDatabase(byte[] decompressed, ProtectedStringCrypto protectedStringCrypto) {
        KeePassFile unprocessedKeepassFile = this.keePassDatabaseXmlParser.fromXml(new ByteArrayInputStream(decompressed));
        new ProtectedValueProcessor().processProtectedValues(new DecryptionStrategy(protectedStringCrypto), unprocessedKeepassFile);
        return new IconEnricher().enrichNodesWithIconData(unprocessedKeepassFile);
    }

    private ProtectedStringCrypto getProtectedStringCrypto() {
        if (!this.keepassHeader.getCrsAlgorithm().equals((Object)CrsAlgorithm.Salsa20)) {
            throw new UnsupportedOperationException("Only Salsa20 is supported as CrsAlgorithm at the moment!");
        }
        Salsa20 protectedStringCrypto = Salsa20.createInstance(this.keepassHeader.getProtectedStreamKey());
        return protectedStringCrypto;
    }

    private byte[] decompressStream(byte[] hashedBlockBytes) throws IOException {
        byte[] decompressed = hashedBlockBytes;
        if (this.keepassHeader.getCompression().equals((Object)CompressionAlgorithm.Gzip)) {
            GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(hashedBlockBytes));
            decompressed = StreamUtils.toByteArray(gzipInputStream);
        }
        return decompressed;
    }

    private SafeInputStream skipMetadata(byte[] aesDecryptedDbFile) throws IOException {
        SafeInputStream decryptedStream = new SafeInputStream(new ByteArrayInputStream(aesDecryptedDbFile));
        byte[] startBytes = new byte[32];
        decryptedStream.skipSafe(12 + this.keepassHeader.getHeaderSize());
        decryptedStream.readSafe(startBytes);
        if (!Arrays.equals(this.keepassHeader.getStreamStartBytes(), startBytes)) {
            throw new KeePassDatabaseUnreadableException("The keepass database file seems to be corrupt or cannot be decrypted.");
        }
        return decryptedStream;
    }

    private byte[] decryptStream(byte[] key, byte[] keepassFile) throws IOException {
        CryptoInformation cryptoInformation = new CryptoInformation(12, this.keepassHeader.getMasterSeed(), this.keepassHeader.getTransformSeed(), this.keepassHeader.getEncryptionIV(), this.keepassHeader.getTransformRounds(), this.keepassHeader.getHeaderSize());
        return this.decrypter.decryptDatabase(key, cryptoInformation, keepassFile);
    }
}

