/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.EntryContract;
import de.slackspace.openkeepass.domain.History;
import de.slackspace.openkeepass.domain.Property;
import de.slackspace.openkeepass.domain.Times;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class EntryBuilder
implements EntryContract {
    private UUID uuid;
    private History history;
    private String title;
    private String username;
    private String password;
    private String notes;
    private String url;
    private Entry originalEntry;
    private int iconId;
    private byte[] iconData;
    private UUID customIconUUID;
    private Times times;
    private List<Property> customPropertyList = new ArrayList<Property>();

    public EntryBuilder() {
        this.uuid = UUID.randomUUID();
    }

    public EntryBuilder(UUID uuid) {
        this.uuid = uuid;
    }

    public EntryBuilder(String title) {
        this();
        this.title = title;
    }

    public EntryBuilder(Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter entry must not be null");
        }
        this.originalEntry = entry;
        this.uuid = entry.getUuid();
        this.title = entry.getTitle();
        this.history = entry.getHistory();
        this.username = entry.getUsername();
        this.password = entry.getPassword();
        this.notes = entry.getNotes();
        this.url = entry.getUrl();
        this.iconId = entry.getIconId();
        this.iconData = entry.getIconData();
        this.customIconUUID = entry.getCustomIconUuid();
        this.customPropertyList.addAll(entry.getCustomProperties());
        this.times = entry.getTimes();
    }

    public EntryBuilder title(String title) {
        this.title = title;
        return this;
    }

    public EntryBuilder uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public EntryBuilder username(String username) {
        this.username = username;
        return this;
    }

    public EntryBuilder password(String password) {
        this.password = password;
        return this;
    }

    public EntryBuilder notes(String notes) {
        this.notes = notes;
        return this;
    }

    public EntryBuilder history(History history) {
        this.history = history;
        return this;
    }

    public EntryBuilder url(String url) {
        this.url = url;
        return this;
    }

    public EntryBuilder iconData(byte[] iconData) {
        this.iconData = iconData;
        return this;
    }

    public EntryBuilder iconId(int iconId) {
        this.iconId = iconId;
        return this;
    }

    public EntryBuilder customIconUuid(UUID uuid) {
        this.customIconUUID = uuid;
        return this;
    }

    public EntryBuilder times(Times times) {
        this.times = times;
        return this;
    }

    public EntryBuilder clearHistory() {
        this.history = new History();
        return this;
    }

    public Entry build() {
        return new Entry(this);
    }

    public Entry buildWithHistory() {
        if (this.originalEntry == null) {
            throw new IllegalArgumentException("originalEntry is not set");
        }
        if (this.history == null) {
            this.history = new History();
        }
        Entry entryWithoutHistory = new EntryBuilder(this.originalEntry).history(new History()).build();
        this.history.getHistoricEntries().add(entryWithoutHistory);
        return this.build();
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public byte[] getIconData() {
        return this.iconData;
    }

    @Override
    public int getIconId() {
        return this.iconId;
    }

    @Override
    public UUID getCustomIconUUID() {
        return this.customIconUUID;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public List<Property> getCustomPropertyList() {
        return this.customPropertyList;
    }

    @Override
    public History getHistory() {
        return this.history;
    }

    @Override
    public Times getTimes() {
        return this.times;
    }
}

