/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.processor;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.History;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.Property;
import de.slackspace.openkeepass.domain.PropertyValue;
import de.slackspace.openkeepass.processor.ProtectionStrategy;
import java.util.ArrayList;
import java.util.List;

public class ProtectedValueProcessor {
    public void processProtectedValues(ProtectionStrategy strategy, KeePassFile keePassFile) {
        List<Entry> entries = keePassFile.getEntries();
        for (Entry entry : entries) {
            this.encryptOrDecryptProtectedValues(strategy, entry);
            History history = entry.getHistory();
            if (history == null) continue;
            for (Entry historicEntry : history.getHistoricEntries()) {
                this.encryptOrDecryptProtectedValues(strategy, historicEntry);
            }
        }
    }

    private void encryptOrDecryptProtectedValues(ProtectionStrategy strategy, Entry entry) {
        ArrayList<Property> removeList = new ArrayList<Property>();
        ArrayList<Property> addList = new ArrayList<Property>();
        List<Property> properties = entry.getProperties();
        for (Property property : properties) {
            this.handleProtectedValue(strategy, removeList, addList, property);
        }
        properties.removeAll(removeList);
        properties.addAll(addList);
    }

    private void handleProtectedValue(ProtectionStrategy strategy, List<Property> removeList, List<Property> addList, Property property) {
        PropertyValue propertyValue = property.getPropertyValue();
        if (ProtectedValueProcessor.isPropertyValueProtected(propertyValue)) {
            String processedValue = strategy.apply(propertyValue.getValue());
            removeList.add(property);
            addList.add(new Property(property.getKey(), processedValue, property.isProtected()));
        }
    }

    private static boolean isPropertyValueProtected(PropertyValue propertyValue) {
        return propertyValue.getValue() != null && !propertyValue.getValue().isEmpty() && propertyValue.isProtected();
    }
}

