/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.Times;
import de.slackspace.openkeepass.domain.TimesContract;
import java.util.Calendar;

public class TimesBuilder
implements TimesContract {
    private Calendar lastModificationTime;
    private Calendar creationTime;
    private Calendar lastAccessTime;
    private Calendar expiryTime;
    private boolean expires;
    private int usageCount;
    private Calendar locationChanged;

    public TimesBuilder() {
    }

    public TimesBuilder(Times times) {
        this.lastModificationTime = times.getLastModificationTime();
        this.creationTime = times.getCreationTime();
        this.lastAccessTime = times.getLastAccessTime();
        this.expiryTime = times.getExpiryTime();
        this.expires = times.expires();
        this.usageCount = times.getUsageCount();
        this.locationChanged = times.getLocationChanged();
    }

    public TimesBuilder lastModificationTime(Calendar lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
        return this;
    }

    public TimesBuilder creationTime(Calendar creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public TimesBuilder lastAccessTime(Calendar lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public TimesBuilder expiryTime(Calendar expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public TimesBuilder expires(boolean expires) {
        this.expires = expires;
        return this;
    }

    public TimesBuilder usageCount(int usageCount) {
        this.usageCount = usageCount;
        return this;
    }

    public TimesBuilder locationChanged(Calendar locationChanged) {
        this.locationChanged = locationChanged;
        return this;
    }

    public Times build() {
        return new Times(this);
    }

    @Override
    public Calendar getLastModificationTime() {
        return this.lastModificationTime;
    }

    @Override
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Calendar getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public Calendar getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    public boolean getExpires() {
        return this.expires;
    }

    @Override
    public int getUsageCount() {
        return this.usageCount;
    }

    @Override
    public Calendar getLocationChanged() {
        return this.locationChanged;
    }
}

