/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.parser;

import de.slackspace.openkeepass.domain.PropertyValue;
import de.slackspace.openkeepass.domain.xml.adapter.BooleanSimpleXmlAdapter;
import de.slackspace.openkeepass.domain.xml.adapter.ByteSimpleXmlAdapter;
import de.slackspace.openkeepass.domain.xml.adapter.CalendarSimpleXmlAdapter;
import de.slackspace.openkeepass.domain.xml.adapter.PropertyValueXmlAdapter;
import de.slackspace.openkeepass.domain.xml.adapter.TreeStrategyWithoutArrayLength;
import de.slackspace.openkeepass.domain.xml.adapter.UUIDSimpleXmlAdapter;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnreadableException;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnwriteableException;
import de.slackspace.openkeepass.parser.XmlParser;
import de.slackspace.openkeepass.processor.ProtectionStrategy;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.RegistryMatcher;

public class SimpleXmlParser
implements XmlParser {
    @Override
    public <T> T fromXml(InputStream inputStream, ProtectionStrategy protectionStrategy, Class<T> clazz) {
        try {
            Serializer serializer = this.createSerializer(protectionStrategy);
            return (T)serializer.read(clazz, inputStream);
        }
        catch (Exception e) {
            throw new KeePassDatabaseUnreadableException("Could not deserialize object to xml", e);
        }
    }

    @Override
    public ByteArrayOutputStream toXml(Object objectToSerialize) {
        try {
            RegistryMatcher matcher = new RegistryMatcher();
            matcher.bind(Boolean.class, BooleanSimpleXmlAdapter.class);
            matcher.bind(GregorianCalendar.class, CalendarSimpleXmlAdapter.class);
            matcher.bind(UUID.class, UUIDSimpleXmlAdapter.class);
            matcher.bind(byte[].class, ByteSimpleXmlAdapter.class);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            TreeStrategyWithoutArrayLength strategy = new TreeStrategyWithoutArrayLength();
            Persister serializer = new Persister((Strategy)strategy, (Matcher)matcher);
            serializer.write(objectToSerialize, (OutputStream)outputStream);
            return outputStream;
        }
        catch (Exception e) {
            throw new KeePassDatabaseUnwriteableException("Could not serialize object to xml", e);
        }
    }

    private Serializer createSerializer(ProtectionStrategy protectionStrategy) {
        RegistryMatcher matcher = new RegistryMatcher();
        matcher.bind(Boolean.class, BooleanSimpleXmlAdapter.class);
        matcher.bind(GregorianCalendar.class, CalendarSimpleXmlAdapter.class);
        matcher.bind(UUID.class, UUIDSimpleXmlAdapter.class);
        matcher.bind(byte[].class, ByteSimpleXmlAdapter.class);
        Registry registry = new Registry();
        PropertyValueXmlAdapter converter = new PropertyValueXmlAdapter(protectionStrategy);
        try {
            registry.bind(PropertyValue.class, (Converter)converter);
            RegistryStrategy strategy = new RegistryStrategy(registry);
            return new Persister((Strategy)strategy, (Matcher)matcher);
        }
        catch (Exception e) {
            throw new KeePassDatabaseUnreadableException("Could not register xml converter", e);
        }
    }
}

