/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain.zipper;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.EntryBuilder;
import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.GroupBuilder;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.KeePassFileBuilder;
import de.slackspace.openkeepass.domain.Meta;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class GroupZipper {
    private Meta meta;
    private int index = 0;
    private Group node;
    private GroupZipper parent;

    public GroupZipper(KeePassFile keePassFile) {
        this.meta = keePassFile.getMeta();
        this.node = keePassFile.getRoot().getGroups().get(0);
    }

    private GroupZipper(GroupZipper parent, Group group, int index) {
        this.parent = parent;
        this.node = group;
        this.index = index;
    }

    public boolean canDown() {
        return this.node.getGroups() != null && !this.node.getGroups().isEmpty();
    }

    public GroupZipper down() {
        if (!this.canDown()) {
            throw new NoSuchElementException("Could not move down because this group does not have any children");
        }
        this.parent = new GroupZipper(this.parent, this.node, this.index);
        this.index = 0;
        this.node = this.node.getGroups().get(0);
        return this;
    }

    public boolean canUp() {
        return this.parent != null;
    }

    public GroupZipper up() {
        if (!this.canUp()) {
            throw new NoSuchElementException("Could not move up because this group does not have a parent");
        }
        this.index = this.parent.index;
        this.node = this.parent.node;
        this.parent = this.parent.parent;
        return this;
    }

    public boolean canRight() {
        if (this.parent == null) {
            return false;
        }
        return this.index + 1 < this.parent.getNode().getGroups().size();
    }

    public GroupZipper right() {
        if (!this.canRight()) {
            throw new NoSuchElementException("Could not move right because the last node at this level has already been reached");
        }
        ++this.index;
        this.node = this.parent.getNode().getGroups().get(this.index);
        return this;
    }

    public boolean canLeft() {
        return this.index - 1 >= 0;
    }

    public GroupZipper left() {
        if (!this.canLeft()) {
            throw new NoSuchElementException("Could not move left because the first node at this level has already been reached");
        }
        --this.index;
        this.node = this.parent.getNode().getGroups().get(this.index);
        return this;
    }

    public Group getNode() {
        return this.node;
    }

    public GroupZipper replace(Group group) {
        if (this.parent == null) {
            this.node = group;
        } else {
            this.parent.getNode().getGroups().set(this.index, group);
        }
        return this;
    }

    public KeePassFile close() {
        Group rootNode = this.getRoot();
        return new KeePassFileBuilder(this.meta).addTopGroups(rootNode).build();
    }

    public KeePassFile cloneKeePassFile() {
        Iterator<Group> iter = this.iterator();
        while (iter.hasNext()) {
            Group group = iter.next();
            Group clonedGroup = this.cloneGroup(group);
            this.replace(clonedGroup);
        }
        return this.close();
    }

    private Group cloneGroup(Group group) {
        GroupBuilder groupBuilder = new GroupBuilder(group);
        this.cloneEntriesInGroup(group, groupBuilder);
        Group clonedGroup = groupBuilder.build();
        return clonedGroup;
    }

    private void cloneEntriesInGroup(Group group, GroupBuilder groupBuilder) {
        ArrayList<Entry> removeList = new ArrayList<Entry>();
        ArrayList<Entry> addList = new ArrayList<Entry>();
        List<Entry> entries = group.getEntries();
        for (Entry entry : entries) {
            this.cloneEntry(entry, removeList, addList);
        }
        groupBuilder.removeEntries(removeList);
        groupBuilder.addEntries(addList);
    }

    private void cloneEntry(Entry entry, List<Entry> removeList, List<Entry> addList) {
        Entry clonedEntry = new EntryBuilder(entry).build();
        removeList.add(entry);
        addList.add(clonedEntry);
    }

    public Group getRoot() {
        if (this.parent == null) {
            return this.node;
        }
        return this.parent.getRoot();
    }

    public GroupZipper replaceMeta(Meta meta) {
        this.meta = meta;
        return this;
    }

    public String toString() {
        return "GroupZipper [index=" + this.index + ", node=" + this.node + "]";
    }

    public Iterator<Group> iterator() {
        return new GroupIterator();
    }

    private class GroupIterator
    implements Iterator<Group> {
        boolean isFirst = true;

        private GroupIterator() {
        }

        private boolean canGoRightAtAnyLevel(GroupZipper parent) {
            if (parent == null) {
                return false;
            }
            if (parent.canRight()) {
                return true;
            }
            return this.canGoRightAtAnyLevel(parent.parent);
        }

        private Group getNextRightNode(GroupZipper parent) {
            if (parent == null) {
                return null;
            }
            if (parent.canRight()) {
                return GroupZipper.this.up().right().getNode();
            }
            return this.getNextRightNode(parent.up());
        }

        @Override
        public boolean hasNext() {
            if (this.isFirst) {
                return true;
            }
            if (GroupZipper.this.canDown() || GroupZipper.this.canRight()) {
                return true;
            }
            return this.canGoRightAtAnyLevel(GroupZipper.this.parent);
        }

        @Override
        public Group next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.isFirst) {
                this.isFirst = false;
                return GroupZipper.this.getNode();
            }
            if (GroupZipper.this.canDown()) {
                return GroupZipper.this.down().getNode();
            }
            if (GroupZipper.this.canRight()) {
                return GroupZipper.this.right().getNode();
            }
            return this.getNextRightNode(GroupZipper.this.parent);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported by GroupIterator");
        }
    }
}

