/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    private StreamUtils() {
    }

    public static int read(InputStream input, byte[] buffer) throws IOException {
        int location;
        int remaining;
        int count;
        if (input == null || buffer == null) {
            return -1;
        }
        for (remaining = buffer.length; remaining > 0 && -1 != (count = input.read(buffer, 0 + (location = buffer.length - remaining), remaining)); remaining -= count) {
        }
        return buffer.length - remaining;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamUtils.copyLarge(input, output, new byte[4096]);
        return output.toByteArray();
    }

    private static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

