/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.osiris.diagnosis;

import de.slackspace.osiris.diagnosis.InvocationContextParser;
import de.slackspace.osiris.diagnosis.Monitored;
import de.slackspace.osiris.diagnosis.ResultConverter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Monitored
@Interceptor
@Priority(value=1000)
public class MonitoringInterceptor {
    private final Map<String, Logger> loggers = new HashMap<String, Logger>();
    @Inject
    InvocationContextParser ctxParser;
    @Inject
    ResultConverter resultConverter;

    @AroundInvoke
    public Object logInvocation(InvocationContext ctx) throws Exception {
        String thread = Thread.currentThread().getName();
        Monitored monitored = ctx.getMethod().getAnnotation(Monitored.class);
        Logger logger = this.findLogger(monitored.layer());
        this.logBeforeProceed(logger, monitored.useCase(), thread, ctx);
        long startTime = System.nanoTime();
        Object result = ctx.proceed();
        long executionTimeMs = (System.nanoTime() - startTime) / 1000000L;
        this.logAfterProceed(logger, monitored.useCase(), thread, ctx, executionTimeMs, result);
        return result;
    }

    private void logBeforeProceed(Logger logger, String useCase, String thread, InvocationContext ctx) {
        logger.debug("UseCase: [{}] Thread: [{}] Method: [{}] Args: [{}]", new Object[]{useCase, thread, this.ctxParser.getFullMethodName(ctx), this.ctxParser.getParameters(ctx)});
    }

    private void logAfterProceed(Logger logger, String useCase, String thread, InvocationContext ctx, long executionTimeMs, Object result) {
        String resultString = this.resultConverter.convertToString(result);
        logger.debug("UseCase: [{}] Thread: [{}] Method: [{}] Took: [{} ms] Returned: [{}]", new Object[]{useCase, thread, this.ctxParser.getFullMethodName(ctx), executionTimeMs, resultString});
    }

    private Logger findLogger(String layer) {
        if (!this.loggers.containsKey(layer)) {
            this.loggers.put(layer, LoggerFactory.getLogger((String)layer));
        }
        return this.loggers.get(layer);
    }
}

