/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.bool;

import de.softwareforge.bool.BoolEval;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionTest {
    @Test
    public void testLiterals() {
        BoolEval test = new BoolEval("TRUE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("FALSE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
    }

    @Test
    public void testNotLiterals() {
        BoolEval test = new BoolEval("NOT FALSE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("NOT TRUE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
    }

    @Test
    public void testParens() {
        BoolEval test = new BoolEval("( TRUE )");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval(" (FALSE) ");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("NOT (FALSE)");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("(NOT TRUE)");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
    }

    @Test
    public void testAnd() {
        BoolEval test = new BoolEval("FALSE AND FALSE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("FALSE AND TRUE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("TRUE AND FALSE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("TRUE AND TRUE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
    }

    @Test
    public void testOr() {
        BoolEval test = new BoolEval("FALSE OR FALSE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("FALSE OR TRUE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("TRUE OR FALSE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("TRUE OR TRUE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
    }

    @Test
    public void testLeftAssoc() {
        BoolEval test = new BoolEval("FALSE AND TRUE OR FALSE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("TRUE OR FALSE AND TRUE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
    }

    @Test
    public void testNotAssoc() {
        BoolEval test = new BoolEval("NOT FALSE AND TRUE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("NOT FALSE AND NOT FALSE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("NOT (FALSE AND TRUE)");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("TRUE AND NOT FALSE");
        Assertions.assertTrue((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("NOT TRUE OR FALSE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("NOT TRUE OR NOT TRUE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("NOT (TRUE OR FALSE)");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
        test = new BoolEval("FALSE OR NOT TRUE");
        Assertions.assertFalse((boolean)test.evaluate(this.failingProvider()));
    }

    private Function<String, Boolean> failingProvider() {
        return name -> (Boolean)Assertions.fail((String)String.format("requested identifier %s unknown", name));
    }
}

