/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.bool;

import de.softwareforge.bool.BoolEval;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdentifierTest {
    @Test
    public void testValues() {
        BoolEval test = new BoolEval("trueValue");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("falseValue");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
    }

    @Test
    public void testBadValue() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            BoolEval test = new BoolEval("nullValue");
            Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
        });
    }

    @Test
    public void testNotLiterals() {
        BoolEval test = new BoolEval("NOT falseValue");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("NOT trueValue");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
    }

    @Test
    public void testParens() {
        BoolEval test = new BoolEval("( trueValue )");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval(" (falseValue) ");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("NOT (falseValue)");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("(NOT trueValue)");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
    }

    @Test
    public void testAnd() {
        BoolEval test = new BoolEval("falseValue AND falseValue");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("falseValue AND trueValue");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("trueValue AND falseValue");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("trueValue AND trueValue");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
    }

    @Test
    public void testOr() {
        BoolEval test = new BoolEval("falseValue OR falseValue");
        Assertions.assertFalse((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("falseValue OR trueValue");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("trueValue OR falseValue");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
        test = new BoolEval("trueValue OR trueValue");
        Assertions.assertTrue((boolean)test.evaluate(this.constantProvider()));
    }

    private Function<String, Boolean> constantProvider() {
        return name -> {
            switch (name) {
                case "trueValue": {
                    return Boolean.TRUE;
                }
                case "falseValue": {
                    return Boolean.FALSE;
                }
                case "nullValue": {
                    return null;
                }
            }
            Assertions.fail((String)String.format("requested identifier %s unknown", name));
            return null;
        };
    }
}

