/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import de.softwareforge.kafka.LoadCommand;
import io.airlift.command.Cli;
import io.airlift.command.Command;
import io.airlift.command.Help;
import io.airlift.command.ParseException;
import java.util.concurrent.Callable;
import javax.inject.Inject;

public class TpchMain {
    public static final Cli<TpchCommand> TPCH_PARSER;

    public static void main(String[] args) throws Exception {
        try {
            System.exit(((TpchCommand)TPCH_PARSER.parse(args)).call());
        }
        catch (ParseException e) {
            System.out.println((String)Objects.firstNonNull((Object)e.getMessage(), (Object)"Unknown command line parser error"));
            System.exit(100);
        }
    }

    static {
        Cli.CliBuilder builder = Cli.builder((String)"kafka-tpch").withDescription("Kafka TPCH Loader").withDefaultCommand(HelpCommand.class).withCommand(LoadCommand.class).withCommand(HelpCommand.class);
        TPCH_PARSER = builder.build();
    }

    @Command(name="help", description="Display help")
    public static class HelpCommand
    extends TpchCommand {
        @Inject
        public Help help;

        @Override
        public void execute() throws Exception {
            this.help.call();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("HelpCommand{help=").append(this.help).append('}');
            return sb.toString();
        }
    }

    public static abstract class TpchCommand
    implements Callable<Integer> {
        @Override
        public final Integer call() throws Exception {
            try {
                this.execute();
                return 0;
            }
            catch (Exception e) {
                System.err.println((String)Objects.firstNonNull((Object)e.getMessage(), (Object)"Unknown error"));
                return 1;
            }
        }

        @VisibleForTesting
        public abstract void execute() throws Exception;
    }
}

