/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import java.io.Serializable;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Version UNKNOWN_VERSION = new Version(0, 0, 0, null, null, null);
    protected final int _majorVersion;
    protected final int _minorVersion;
    protected final int _patchLevel;
    protected final String _groupId;
    protected final String _artifactId;
    protected final String _snapshotInfo;

    @Deprecated
    public Version(int n, int n2, int n3, String string2) {
        this(n, n2, n3, string2, null, null);
    }

    public Version(int n, int n2, int n3, String string2, String string3, String string4) {
        this._majorVersion = n;
        this._minorVersion = n2;
        this._patchLevel = n3;
        this._snapshotInfo = string2;
        this._groupId = string3 == null ? "" : string3;
        this._artifactId = string4 == null ? "" : string4;
    }

    public static Version unknownVersion() {
        return UNKNOWN_VERSION;
    }

    public boolean isUknownVersion() {
        return this == UNKNOWN_VERSION;
    }

    public boolean isSnapshot() {
        return this._snapshotInfo != null && this._snapshotInfo.length() > 0;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getPatchLevel() {
        return this._patchLevel;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String toFullString() {
        return this._groupId + '/' + this._artifactId + '/' + this.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._majorVersion).append('.');
        stringBuilder.append(this._minorVersion).append('.');
        stringBuilder.append(this._patchLevel);
        if (this.isSnapshot()) {
            stringBuilder.append('-').append(this._snapshotInfo);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this._artifactId.hashCode() ^ this._groupId.hashCode() + this._majorVersion - this._minorVersion + this._patchLevel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return version._majorVersion == this._majorVersion && version._minorVersion == this._minorVersion && version._patchLevel == this._patchLevel && version._artifactId.equals(this._artifactId) && version._groupId.equals(this._groupId);
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int n = this._groupId.compareTo(version._groupId);
        if (n == 0 && (n = this._artifactId.compareTo(version._artifactId)) == 0 && (n = this._majorVersion - version._majorVersion) == 0 && (n = this._minorVersion - version._minorVersion) == 0) {
            n = this._patchLevel - version._patchLevel;
        }
        return n;
    }
}

